/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports;

import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import java.util.List;

public class ThroughputReport {
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private final PerformanceReport performanceReport;

    public ThroughputReport(PerformanceReport performanceReport) {
        this.performanceReport = performanceReport;
    }

    public double get() {
        Long throughput = this.performanceReport.getThroughput();
        if (throughput != null) {
            return throughput.longValue();
        }
        List<UriReport> uriReports = this.performanceReport.getUriListOrdered();
        if (uriReports.isEmpty()) {
            return 0.0;
        }
        long sumSamplesCount = 0L;
        long startTime = Long.MAX_VALUE;
        long endTime = 0L;
        for (UriReport uriReport : uriReports) {
            sumSamplesCount += (long)uriReport.samplesCount();
            if (startTime > uriReport.getStart().getTime()) {
                startTime = uriReport.getStart().getTime();
            }
            if (endTime >= uriReport.getEnd().getTime()) continue;
            endTime = uriReport.getEnd().getTime();
        }
        long duration = endTime - startTime;
        if (duration == 0L) {
            return sumSamplesCount;
        }
        return (double)sumSamplesCount / ((double)duration / 1000.0);
    }
}

