/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports;

import hudson.model.Run;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.data.TaurusFinalStats;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.reports.AbstractReport;
import hudson.plugins.performance.reports.UriReport;
import hudson.plugins.performance.tools.SafeMaths;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class PerformanceReport
extends AbstractReport
implements Serializable,
Comparable<PerformanceReport> {
    private static final long serialVersionUID = 675698410989941826L;
    private transient PerformanceBuildAction buildAction;
    private String reportFileName = null;
    private final Map<String, UriReport> uriReportMap = new LinkedHashMap<String, UriReport>();
    private PerformanceReport lastBuildReport;
    private transient List<Long> durationsSortedBySize = null;
    private transient List<UriReport> uriReportsOrdered = null;
    private int nbError = 0;
    private float summarizerErrors = 0.0f;
    private int size;
    private int samplesCount;
    private long totalDuration = 0L;
    private double totalSizeInKB = 0.0;
    private long summarizerMin;
    private long summarizerMax;
    private long summarizerAvg;
    private String summarizerErrorPercent = null;
    private long summarizerSize;
    private Long average;
    private Long perc0;
    private Long perc50;
    private Long perc90;
    private Long perc100;
    private Long throughput;
    protected String percentiles;

    public PerformanceReport() {
        if (StringUtils.isBlank((String)this.percentiles)) {
            this.percentiles = "0,50,90,100";
        }
    }

    public PerformanceReport(String percentiles) {
        this.percentiles = percentiles;
    }

    public Object readResolve() {
        if (this.size != 0) {
            this.samplesCount = this.size;
        }
        if (this.throughput == null) {
            for (UriReport uriReport : this.getUriListOrdered()) {
                Long uriThroughput = uriReport.getThroughput();
                if (uriThroughput == null) continue;
                this.throughput = this.throughput == null ? uriThroughput : uriThroughput + this.throughput;
            }
        }
        this.checkPercentileAndSet(0.0, this.perc0);
        this.checkPercentileAndSet(50.0, this.perc50);
        this.checkPercentileAndSet(90.0, this.perc90);
        this.checkPercentileAndSet(100.0, this.perc100);
        if (StringUtils.isBlank((String)this.percentiles)) {
            this.percentiles = "0,50,90,100";
        }
        return this;
    }

    public static String asStaplerURI(String uri) {
        return uri.replace("http:", "").replace("https:", "").replaceAll("/", "_").replaceAll(":", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        String staplerUri = PerformanceReport.asStaplerURI(uri);
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            UriReport uriReport = this.uriReportMap.get(staplerUri);
            if (uriReport == null) {
                uriReport = new UriReport(this, staplerUri, uri);
                uriReport.setExcludeResponseTime(this.excludeResponseTime);
                this.uriReportMap.put(staplerUri, uriReport);
            }
            uriReport.addHttpSample(pHttpSample);
            this.durationsSortedBySize = null;
            this.uriReportsOrdered = null;
        }
        if (!pHttpSample.isSuccessful()) {
            ++this.nbError;
        }
        this.summarizerErrors += pHttpSample.getSummarizerErrors();
        ++this.samplesCount;
        if (this.isIncludeResponseTime(pHttpSample)) {
            this.totalDuration += pHttpSample.getDuration();
        }
        this.totalSizeInKB += pHttpSample.getSizeInKb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(TaurusFinalStats sample, boolean isSummaryReport) {
        String uri = sample.getLabel();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        if (isSummaryReport) {
            int sampleCount;
            this.nbError = sample.getFail();
            this.summarizerErrors = this.nbError;
            this.samplesCount = sampleCount = sample.getFail() + sample.getSucc();
            Double testDuration = sample.getTestDuration();
            this.totalDuration = testDuration == null ? (long)sample.getAverageResponseTime() * (long)sampleCount : testDuration.longValue();
            this.totalSizeInKB = sample.getBytes();
            this.average = (long)sample.getAverageResponseTime();
            this.perc50 = (long)sample.getPerc50();
            this.perc90 = (long)sample.getPerc90();
            this.perc0 = (long)sample.getPerc0();
            this.perc100 = (long)sample.getPerc100();
            this.percentilesValues.put(0.0, (long)sample.getPerc0());
            this.percentilesValues.put(50.0, (long)sample.getPerc50());
            this.percentilesValues.put(90.0, (long)sample.getPerc90());
            this.percentilesValues.put(100.0, (long)sample.getPerc100());
            this.calculateDiffPercentiles();
            this.isCalculatedPercentilesValues = true;
            long durationSec = (long)Math.ceil((float)this.totalDuration / 1000.0f);
            if (durationSec < 1L) {
                LOGGER.log(Level.INFO, String.format("Performance test had a duration of only %d second(s), please check your configuration.", durationSec));
            }
            this.throughput = testDuration == null ? sample.getThroughput() : (long)SafeMaths.safeDivide(sampleCount, durationSec);
        } else {
            String staplerUri = PerformanceReport.asStaplerURI(uri);
            Map<String, UriReport> map = this.uriReportMap;
            synchronized (map) {
                UriReport uriReport = this.uriReportMap.get(staplerUri);
                if (uriReport == null) {
                    uriReport = new UriReport(this, staplerUri, uri);
                    this.uriReportMap.put(staplerUri, uriReport);
                }
                uriReport.setFromTaurusFinalStats(sample);
                this.durationsSortedBySize = null;
                this.uriReportsOrdered = null;
            }
        }
    }

    @Override
    public int compareTo(PerformanceReport jmReport) {
        if (this == jmReport) {
            return 0;
        }
        return this.getReportFileName().compareTo(jmReport.getReportFileName());
    }

    @Override
    public int countErrors() {
        return this.nbError;
    }

    @Override
    public double errorPercent() {
        if (this.ifSummarizerParserUsed(this.reportFileName)) {
            if (this.uriReportMap.size() == 0) {
                return 0.0;
            }
            return (double)Math.round((double)(this.summarizerErrors / (float)this.uriReportMap.size()) * 1000.0) / 1000.0;
        }
        return (double)Math.round((this.samplesCount() == 0 ? 0.0 : SafeMaths.safeDivide(this.countErrors(), this.samplesCount()) * 100.0) * 1000.0) / 1000.0;
    }

    @Override
    public long getAverage() {
        if (this.average == null) {
            this.average = this.samplesCount == 0 ? 0L : (long)SafeMaths.safeDivide(this.totalDuration, this.samplesCount);
        }
        return this.average;
    }

    public double getAverageSizeInKb() {
        if (this.samplesCount == 0) {
            return 0.0;
        }
        return this.roundTwoDecimals(SafeMaths.safeDivide(this.totalSizeInKB, this.samplesCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDurationAt(double percentage) {
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("Argument 'percentage' must be a value between 0 and 100 (inclusive)");
        }
        if (this.samplesCount == 0) {
            return 0L;
        }
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.durationsSortedBySize == null) {
                this.durationsSortedBySize = new ArrayList<Long>();
                for (UriReport currentReport : this.uriReportMap.values()) {
                    this.durationsSortedBySize.addAll(currentReport.getDurations());
                }
                Collections.sort(this.durationsSortedBySize);
            }
            if (this.durationsSortedBySize.isEmpty()) {
                return 0L;
            }
            double percentInDecimals = percentage / 100.0;
            int indexToReturn = (int)((double)this.durationsSortedBySize.size() * percentInDecimals) - 1;
            if (indexToReturn < 0) {
                indexToReturn = 0;
            } else if (indexToReturn >= this.durationsSortedBySize.size()) {
                indexToReturn = this.durationsSortedBySize.size() - 1;
            }
            return this.durationsSortedBySize.get(indexToReturn);
        }
    }

    @Override
    public void calculatePercentiles() {
        List<Double> percs = super.parsePercentiles(this.percentiles);
        for (Double perc : percs) {
            this.percentilesValues.put(perc, this.getDurationAt(perc));
        }
        this.isCalculatedPercentilesValues = true;
    }

    @Override
    public void calculateDiffPercentiles() {
        List<Double> percs = super.parsePercentiles(this.percentiles);
        for (Double perc : percs) {
            Long diff = 0L;
            if (this.lastBuildReport != null) {
                Long previousValue = this.lastBuildReport.getPercentilesValues().get(perc);
                Long currentValue = this.getPercentilesValues().get(perc);
                if (previousValue != null && currentValue != null) {
                    diff = currentValue - previousValue;
                }
            }
            this.percentilesDiffValues.put(perc, diff);
        }
    }

    @Override
    public long get90Line() {
        if (this.perc90 == null) {
            this.perc90 = this.getDurationAt(90.0);
        }
        return this.perc90;
    }

    @Override
    public long getMedian() {
        if (this.perc50 == null) {
            this.perc50 = this.getDurationAt(50.0);
        }
        return this.perc50;
    }

    @Override
    public String getHttpCode() {
        return "";
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public UriReport getDynamic(String token) throws IOException {
        return this.getUriReportMap().get(token);
    }

    @Override
    public long getMax() {
        if (this.perc100 == null) {
            this.perc100 = this.getDurationAt(100.0);
        }
        return this.perc100;
    }

    public double getTotalTrafficInKb() {
        return this.roundTwoDecimals(this.totalSizeInKB);
    }

    @Override
    public long getMin() {
        if (this.perc0 == null) {
            this.perc0 = this.getDurationAt(0.0);
        }
        return this.perc0;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UriReport> getUriListOrdered() {
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.uriReportsOrdered == null) {
                this.uriReportsOrdered = new ArrayList<UriReport>(this.uriReportMap.values());
                Collections.sort(this.uriReportsOrdered, Collections.reverseOrder());
            }
            return this.uriReportsOrdered;
        }
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    public void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public int samplesCount() {
        return this.samplesCount;
    }

    public void setLastBuildReport(PerformanceReport lastBuildReport) {
        Map<String, UriReport> lastBuildUriReportMap = lastBuildReport.getUriReportMap();
        for (Map.Entry<String, UriReport> item : this.uriReportMap.entrySet()) {
            UriReport lastBuildUri = lastBuildUriReportMap.get(item.getKey());
            if (lastBuildUri == null) continue;
            item.getValue().addLastBuildUriReport(lastBuildUri);
        }
        this.lastBuildReport = lastBuildReport;
        this.calculateDiffPercentiles();
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildReport.getMedian();
    }

    @Override
    public long get90LineDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.get90Line() - this.lastBuildReport.get90Line();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildReport == null) {
            return 0.0;
        }
        return (double)Math.round((this.errorPercent() - this.lastBuildReport.errorPercent()) * 1000.0) / 1000.0;
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        return "";
    }

    @Override
    public int getSamplesCountDiff() {
        if (this.lastBuildReport == null) {
            return 0;
        }
        return this.samplesCount() - this.lastBuildReport.samplesCount();
    }

    public boolean ifSummarizerParserUsed(String filename) {
        PerformanceReportParser parser = this.buildAction.getParserByDisplayName("JmeterSummarizer");
        if (parser != null) {
            String[] parts;
            String fileExt = parser.glob;
            for (String path : parts = fileExt.split("\\s*[;:,]+\\s*")) {
                if (!filename.endsWith(path.substring(5))) continue;
                return true;
            }
        }
        return (parser = this.buildAction.getParserByDisplayName("Iago")) != null;
    }

    private double roundTwoDecimals(double d) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public void setSummarizerSize(long summarizerSize) {
        this.summarizerSize = summarizerSize;
    }

    public long getSummarizerSize() {
        return this.summarizerSize;
    }

    public void setSummarizerMin(long summarizerMin) {
        this.summarizerMin = summarizerMin;
    }

    public long getSummarizerMin() {
        return this.summarizerMin;
    }

    public void setSummarizerMax(long summarizerMax) {
        this.summarizerMax = summarizerMax;
    }

    public long getSummarizerMax() {
        return this.summarizerMax;
    }

    public void setSummarizerAvg(long summarizerAvg) {
        this.summarizerAvg = summarizerAvg;
    }

    public long getSummarizerAvg() {
        return this.summarizerAvg;
    }

    public void setSummarizerErrors(String summarizerErrorPercent) {
        this.summarizerErrorPercent = summarizerErrorPercent;
    }

    public String getSummarizerErrors() {
        return this.summarizerErrorPercent;
    }

    public Long getThroughput() {
        return this.throughput;
    }
}

