/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports.throughput;

import hudson.plugins.performance.reports.UriReport;

public class ThroughputUriReport {
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private final UriReport uriReport;

    public ThroughputUriReport(UriReport uriReport) {
        this.uriReport = uriReport;
    }

    public double get() {
        long start;
        Long throughput = this.uriReport.getThroughput();
        if (throughput != null) {
            return throughput.longValue();
        }
        if (this.uriReport.samplesCount() == 0) {
            return 0.0;
        }
        long end = this.uriReport.getEnd().getTime();
        long duration = end - (start = this.uriReport.getStart().getTime());
        if (duration == 0L) {
            return this.uriReport.samplesCount();
        }
        return (double)this.uriReport.samplesCount() / ((double)duration / 1000.0);
    }
}

