/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.build;

import com.google.common.base.Throwables;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.output.NullOutputStream;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PerformanceTestBuild
extends Builder
implements SimpleBuildStep {
    protected static final String PERFORMANCE_TEST_COMMAND = "bzt";
    protected static final String VIRTUALENV_COMMAND = "virtualenv";
    protected static final String HELP_OPTION = "--help";
    protected static final String VIRTUALENV_PATH_UNIX = "taurus-venv/bin/";
    protected static final String VIRTUALENV_PATH_WINDOWS = "\\taurus-venv\\Scripts\\";
    protected static final String[] CHECK_BZT_COMMAND = new String[]{"bzt", "--help"};
    protected static final String[] CHECK_VIRTUALENV_COMMAND = new String[]{"virtualenv", "--help"};
    protected static final String[] CREATE_LOCAL_PYTHON_COMMAND_WITH_SYSTEM_PACKAGES_OPTION = new String[]{"virtualenv", "--clear", "--system-site-packages", "taurus-venv"};
    protected static final String[] CREATE_LOCAL_PYTHON_COMMAND = new String[]{"virtualenv", "--clear", "taurus-venv"};
    protected static final String DEFAULT_CONFIG_FILE = "jenkins-report.yml";
    private String params;
    private boolean printDebugOutput;
    private boolean useSystemSitePackages;
    private boolean generatePerformanceTrend;
    private boolean useBztExitCode;

    @DataBoundConstructor
    public PerformanceTestBuild(String params, boolean generatePerformanceTrend, boolean printDebugOutput, boolean useSystemSitePackages, boolean useBztFailCriteria) throws IOException {
        this.params = params;
        this.generatePerformanceTrend = generatePerformanceTrend;
        this.printDebugOutput = printDebugOutput;
        this.useSystemSitePackages = useSystemSitePackages;
        this.useBztExitCode = useBztFailCriteria;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return this.generatePerformanceTrend ? new PerformanceProjectAction(project) : null;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        EnvVars envVars = run.getEnvironment(listener);
        boolean isVirtualenvInstallation = false;
        if (this.isGlobalBztInstalled(workspace, logger, launcher, envVars) || (isVirtualenvInstallation = this.installBztAndCheck(workspace, logger, launcher, envVars))) {
            int testExitCode = this.runPerformanceTest(workspace, logger, launcher, envVars, isVirtualenvInstallation);
            run.setResult(this.useBztExitCode ? this.getBztJobResult(testExitCode) : this.getJobResult(testExitCode));
            if (this.generatePerformanceTrend && run.getResult().isBetterThan(Result.FAILURE)) {
                this.generatePerformanceTrend(run, workspace, launcher, listener);
            }
            return;
        }
        run.setResult(Result.FAILURE);
    }

    protected void generatePerformanceTrend(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        new PerformancePublisher("aggregate-results.xml", -1, -1, "", 0.0, 0.0, 0.0, 0.0, 0, false, "", false, false, false, false, null).perform(run, workspace, launcher, listener);
    }

    private boolean installBztAndCheck(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        return this.installBzt(workspace, logger, launcher, envVars) && this.isVirtualenvBztInstalled(workspace, logger, launcher, envVars);
    }

    private boolean installBzt(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        return this.isVirtualenvInstalled(workspace, logger, launcher, envVars) && this.createVirtualenvAndInstallBzt(workspace, logger, launcher, envVars);
    }

    private boolean createVirtualenvAndInstallBzt(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        return this.createIsolatedPython(workspace, logger, launcher, envVars) && this.installBztInVirtualenv(workspace, logger, launcher, envVars);
    }

    private boolean isGlobalBztInstalled(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Checking global bzt installation...");
        boolean result = this.isSuccessCode(this.runCmd(CHECK_BZT_COMMAND, workspace, (OutputStream)new NullOutputStream(), launcher, envVars));
        logger.println(result ? "Performance test: Found global bzt installation." : "Performance test: You don't have global bzt installed on this Jenkins host. Installing it globally will speed up job. Run 'sudo pip install bzt' to install it.");
        return result;
    }

    private boolean isVirtualenvInstalled(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Checking virtualenv tool availability...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(CHECK_VIRTUALENV_COMMAND, workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: Found virtualenv tool." : "Performance test: No virtualenv found on this Jenkins host. Install it with 'sudo pip install virtualenv'.");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private boolean createIsolatedPython(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Creating virtualev at 'taurus-venv'...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(this.useSystemSitePackages ? CREATE_LOCAL_PYTHON_COMMAND_WITH_SYSTEM_PACKAGES_OPTION : CREATE_LOCAL_PYTHON_COMMAND, workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: Done creating virtualenv." : "Performance test: Failed to create virtualenv at 'taurus-venv'");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private boolean installBztInVirtualenv(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Installing bzt into 'taurus-venv'");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(this.getBztInstallCommand(workspace), workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: bzt installed successfully." : "Performance test: Failed to install bzt into 'taurus-venv'");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private boolean isVirtualenvBztInstalled(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Checking installed bzt...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(this.getBztCheckCommand(workspace), workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: bzt is operational." : "Performance test: Failed to run bzt inside virtualenv.");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private int runPerformanceTest(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars, boolean isVirtualenvInstallation) throws InterruptedException, IOException {
        String[] params = this.params.split(" ");
        ArrayList<String> testCommand = new ArrayList<String>(params.length + 2);
        testCommand.add((isVirtualenvInstallation ? this.getVirtualenvPath(workspace) : "") + PERFORMANCE_TEST_COMMAND);
        for (String param : params) {
            if (param.isEmpty()) continue;
            testCommand.add(param);
        }
        if (this.generatePerformanceTrend) {
            testCommand.add(this.extractDefaultReportToWorkspace(workspace));
        }
        logger.println("Performance test: run " + Arrays.toString(testCommand.toArray()));
        return this.runCmd(testCommand.toArray(new String[testCommand.size()]), workspace, logger, launcher, envVars);
    }

    public boolean isSuccessCode(int code) {
        return code == 0;
    }

    public Result getJobResult(int code) {
        if (code == 0) {
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public Result getBztJobResult(int code) {
        if (code == 0) {
            return Result.SUCCESS;
        }
        if (code == 1) {
            return Result.FAILURE;
        }
        return Result.UNSTABLE;
    }

    private String getVirtualenvPath(FilePath workspace) {
        return Functions.isWindows() ? workspace.getRemote() + VIRTUALENV_PATH_WINDOWS : VIRTUALENV_PATH_UNIX;
    }

    private String[] getBztInstallCommand(FilePath workspace) {
        return new String[]{this.getVirtualenvPath(workspace) + "pip", "install", PERFORMANCE_TEST_COMMAND};
    }

    private String[] getBztCheckCommand(FilePath workspace) {
        return new String[]{this.getVirtualenvPath(workspace) + PERFORMANCE_TEST_COMMAND, HELP_OPTION};
    }

    public int runCmd(String[] commands, FilePath workspace, OutputStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        try {
            return launcher.launch().cmds(commands).envs((Map)envVars).stdout(logger).stderr(logger).pwd(workspace).start().join();
        }
        catch (IOException ex) {
            logger.write(ex.getMessage().getBytes());
            if (this.printDebugOutput) {
                logger.write(Throwables.getStackTraceAsString((Throwable)ex).getBytes());
            }
            return 1;
        }
    }

    protected String extractDefaultReportToWorkspace(FilePath workspace) throws IOException, InterruptedException {
        FilePath defaultConfig = workspace.child(DEFAULT_CONFIG_FILE);
        defaultConfig.copyFrom(((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_CONFIG_FILE));
        return defaultConfig.getRemote();
    }

    public String getParams() {
        return this.params;
    }

    @DataBoundSetter
    public void setParams(String params) {
        this.params = params;
    }

    public boolean isPrintDebugOutput() {
        return this.printDebugOutput;
    }

    @DataBoundSetter
    public void setPrintDebugOutput(boolean printDebugOutput) {
        this.printDebugOutput = printDebugOutput;
    }

    public boolean isUseSystemSitePackages() {
        return this.useSystemSitePackages;
    }

    @DataBoundSetter
    public void setUseSystemSitePackages(boolean useSystemSitePackages) {
        this.useSystemSitePackages = useSystemSitePackages;
    }

    public boolean isGeneratePerformanceTrend() {
        return this.generatePerformanceTrend;
    }

    @DataBoundSetter
    public void setGeneratePerformanceTrend(boolean generatePerformanceTrend) {
        this.generatePerformanceTrend = generatePerformanceTrend;
    }

    public boolean isUseBztExitCode() {
        return this.useBztExitCode;
    }

    @DataBoundSetter
    public void setUseBztExitCode(boolean useBztExitCode) {
        this.useBztExitCode = useBztExitCode;
    }

    @Symbol(value={"performanceTest"})
    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.PerformanceTest_Name();
        }
    }
}

