/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.Run;
import hudson.plugins.performance.AbstractReport;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.TaurusStatusReport;
import hudson.plugins.performance.UriReport;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class PerformanceReport
extends AbstractReport
implements Serializable,
Comparable<PerformanceReport> {
    private static final long serialVersionUID = 675698410989941826L;
    private static final double ZERO_PERCENT = 0.0;
    private static final double ONE_HUNDRED_PERCENT = 100.0;
    private static final double NINETY_PERCENT = 90.0;
    private static final double FIFTY_PERCENT = 50.0;
    private transient PerformanceBuildAction buildAction;
    private String reportFileName = null;
    private final Map<String, UriReport> uriReportMap = new LinkedHashMap<String, UriReport>();
    private PerformanceReport lastBuildReport;
    private transient List<Long> durationsSortedBySize = null;
    private transient List<UriReport> uriReportsOrdered = null;
    private int nbError = 0;
    private float summarizerErrors = 0.0f;
    private int samplesCount;
    private long totalDuration = 0L;
    private double totalSizeInKB = 0.0;
    private long summarizerMin;
    private long summarizerMax;
    private long summarizerAvg;
    private String summarizerErrorPercent = null;
    private long summarizerSize;
    private Long average;
    private Long perc0;
    private Long perc50;
    private Long perc90;
    private Long perc100;

    public static String asStaplerURI(String uri) {
        return uri.replace("http:", "").replace("https:", "").replaceAll("/", "_").replaceAll(":", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        String staplerUri = PerformanceReport.asStaplerURI(uri);
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            UriReport uriReport = this.uriReportMap.get(staplerUri);
            if (uriReport == null) {
                uriReport = new UriReport(this, staplerUri, uri);
                this.uriReportMap.put(staplerUri, uriReport);
            }
            uriReport.addHttpSample(pHttpSample);
            this.durationsSortedBySize = null;
            this.uriReportsOrdered = null;
        }
        if (!pHttpSample.isSuccessful()) {
            ++this.nbError;
        }
        this.summarizerErrors += pHttpSample.getSummarizerErrors();
        ++this.samplesCount;
        this.totalDuration += pHttpSample.getDuration();
        this.totalSizeInKB += pHttpSample.getSizeInKb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(TaurusStatusReport sample, boolean isSummaryReport) {
        String uri = sample.getLabel();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        if (isSummaryReport) {
            int sampleCount;
            this.nbError = sample.getFail();
            this.summarizerErrors = this.nbError;
            this.samplesCount = sampleCount = sample.getFail() + sample.getSucc();
            this.totalDuration = (long)sample.getAverageResponseTime() * (long)sampleCount;
            this.totalSizeInKB = sample.getBytes();
            this.average = (long)sample.getAverageResponseTime();
            this.perc50 = (long)sample.getPerc50();
            this.perc90 = (long)sample.getPerc90();
            this.perc0 = (long)sample.getPerc0();
            this.perc100 = (long)sample.getPerc100();
        } else {
            String staplerUri = PerformanceReport.asStaplerURI(uri);
            Map<String, UriReport> map = this.uriReportMap;
            synchronized (map) {
                UriReport uriReport = this.uriReportMap.get(staplerUri);
                if (uriReport == null) {
                    uriReport = new UriReport(this, staplerUri, uri);
                    this.uriReportMap.put(staplerUri, uriReport);
                }
                uriReport.setFromTaurusStatusReport(sample);
                this.durationsSortedBySize = null;
                this.uriReportsOrdered = null;
            }
        }
    }

    @Override
    public int compareTo(PerformanceReport jmReport) {
        if (this == jmReport) {
            return 0;
        }
        return this.getReportFileName().compareTo(jmReport.getReportFileName());
    }

    @Override
    public int countErrors() {
        return this.nbError;
    }

    @Override
    public double errorPercent() {
        if (this.ifSummarizerParserUsed(this.reportFileName)) {
            if (this.uriReportMap.size() == 0) {
                return 0.0;
            }
            return (double)Math.round((double)(this.summarizerErrors / (float)this.uriReportMap.size()) * 1000.0) / 1000.0;
        }
        return (double)Math.round((this.samplesCount() == 0 ? 0.0 : (double)this.countErrors() / (double)this.samplesCount() * 100.0) * 1000.0) / 1000.0;
    }

    @Override
    public long getAverage() {
        if (this.average == null) {
            this.average = this.samplesCount == 0 ? 0L : this.totalDuration / (long)this.samplesCount;
        }
        return this.average;
    }

    public double getAverageSizeInKb() {
        if (this.samplesCount == 0) {
            return 0.0;
        }
        return this.roundTwoDecimals(this.totalSizeInKB / (double)this.samplesCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDurationAt(double percentage) {
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("Argument 'percentage' must be a value between 0 and 100 (inclusive)");
        }
        if (this.samplesCount == 0) {
            return 0L;
        }
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.durationsSortedBySize == null) {
                this.durationsSortedBySize = new ArrayList<Long>();
                for (UriReport currentReport : this.uriReportMap.values()) {
                    this.durationsSortedBySize.addAll(currentReport.getDurations());
                }
                Collections.sort(this.durationsSortedBySize);
            }
            double percentInDecimals = percentage / 100.0;
            int indexToReturn = (int)((double)this.durationsSortedBySize.size() * percentInDecimals) - 1;
            if (indexToReturn < 0) {
                indexToReturn = 0;
            } else if (indexToReturn >= this.durationsSortedBySize.size()) {
                indexToReturn = this.durationsSortedBySize.size() - 1;
            }
            return this.durationsSortedBySize.get(indexToReturn);
        }
    }

    @Override
    public long get90Line() {
        if (this.perc90 == null) {
            this.perc90 = this.getDurationAt(90.0);
        }
        return this.perc90;
    }

    @Override
    public long getMedian() {
        if (this.perc50 == null) {
            this.perc50 = this.getDurationAt(50.0);
        }
        return this.perc50;
    }

    @Override
    public String getHttpCode() {
        return "";
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public UriReport getDynamic(String token) throws IOException {
        return this.getUriReportMap().get(token);
    }

    @Override
    public long getMax() {
        if (this.perc100 == null) {
            this.perc100 = this.getDurationAt(100.0);
        }
        return this.perc100;
    }

    public double getTotalTrafficInKb() {
        return this.roundTwoDecimals(this.totalSizeInKB);
    }

    @Override
    public long getMin() {
        if (this.perc0 == null) {
            this.perc0 = this.getDurationAt(0.0);
        }
        return this.perc0;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UriReport> getUriListOrdered() {
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.uriReportsOrdered == null) {
                this.uriReportsOrdered = new ArrayList<UriReport>(this.uriReportMap.values());
                Collections.sort(this.uriReportsOrdered, Collections.reverseOrder());
            }
            return this.uriReportsOrdered;
        }
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public int samplesCount() {
        return this.samplesCount;
    }

    public void setLastBuildReport(PerformanceReport lastBuildReport) {
        Map<String, UriReport> lastBuildUriReportMap = lastBuildReport.getUriReportMap();
        for (Map.Entry<String, UriReport> item : this.uriReportMap.entrySet()) {
            UriReport lastBuildUri = lastBuildUriReportMap.get(item.getKey());
            if (lastBuildUri == null) continue;
            item.getValue().addLastBuildUriReport(lastBuildUri);
        }
        this.lastBuildReport = lastBuildReport;
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildReport.getMedian();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildReport == null) {
            return 0.0;
        }
        return (double)Math.round((this.errorPercent() - this.lastBuildReport.errorPercent()) * 1000.0) / 1000.0;
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        return "";
    }

    @Override
    public int getSamplesCountDiff() {
        if (this.lastBuildReport == null) {
            return 0;
        }
        return this.samplesCount() - this.lastBuildReport.samplesCount();
    }

    public boolean ifSummarizerParserUsed(String filename) {
        PerformanceReportParser parser = this.buildAction.getParserByDisplayName("JmeterSummarizer");
        if (parser != null) {
            String[] parts;
            String fileExt = parser.glob;
            for (String path : parts = fileExt.split("\\s*[;:,]+\\s*")) {
                if (!filename.endsWith(path.substring(5))) continue;
                return true;
            }
        }
        return (parser = this.buildAction.getParserByDisplayName("Iago")) != null;
    }

    private double roundTwoDecimals(double d) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public void setSummarizerSize(long summarizerSize) {
        this.summarizerSize = summarizerSize;
    }

    public long getSummarizerSize() {
        return this.summarizerSize;
    }

    public void setSummarizerMin(long summarizerMin) {
        this.summarizerMin = summarizerMin;
    }

    public long getSummarizerMin() {
        return this.summarizerMin;
    }

    public void setSummarizerMax(long summarizerMax) {
        this.summarizerMax = summarizerMax;
    }

    public long getSummarizerMax() {
        return this.summarizerMax;
    }

    public void setSummarizerAvg(long summarizerAvg) {
        this.summarizerAvg = summarizerAvg;
    }

    public long getSummarizerAvg() {
        return this.summarizerAvg;
    }

    public void setSummarizerErrors(String summarizerErrorPercent) {
        this.summarizerErrorPercent = summarizerErrorPercent;
    }

    public String getSummarizerErrors() {
        return this.summarizerErrorPercent;
    }
}

