/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.ExternalBuildReport;
import hudson.plugins.performance.JMeterParser;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceProjectAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import hudson.plugins.performance.UriReport;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.constraints.ConstraintChecker;
import hudson.plugins.performance.constraints.ConstraintDescriptor;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.ConstraintFactory;
import hudson.plugins.performance.constraints.ConstraintReport;
import hudson.plugins.performance.constraints.ConstraintSettings;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PerformancePublisher
extends Recorder
implements SimpleBuildStep {
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private String errorUnstableResponseTimeThreshold = "";
    private double relativeFailedThresholdPositive = 0.0;
    private double relativeFailedThresholdNegative = 0.0;
    private double relativeUnstableThresholdPositive = 0.0;
    private double relativeUnstableThresholdNegative = 0.0;
    private int nthBuildNumber = 0;
    private boolean modeRelativeThresholds = false;
    private String configType = "ART";
    private boolean modeOfThreshold = false;
    private boolean failBuildIfNoResultFile = false;
    private boolean compareBuildPrevious = false;
    public static final String ART = "ART";
    public static final String MRT = "MRT";
    public static final String PRT = "PRT";
    public static String optionType = "ART";
    File xmlfile = null;
    String xmlDir = null;
    String xml = "";
    private static final String archive_directory = "archive";
    private boolean modePerformancePerTestCase = false;
    private transient String filename;
    private List<PerformanceReportParser> parsers;
    private boolean modeThroughput;
    private boolean modeEvaluation = false;
    private List<? extends AbstractConstraint> constraints;
    private boolean ignoreFailedBuilds;
    private boolean ignoreUnstableBuilds;
    private boolean persistConstraintLog;

    @DataBoundConstructor
    public PerformancePublisher(int errorFailedThreshold, int errorUnstableThreshold, String errorUnstableResponseTimeThreshold, double relativeFailedThresholdPositive, double relativeFailedThresholdNegative, double relativeUnstableThresholdPositive, double relativeUnstableThresholdNegative, int nthBuildNumber, boolean modePerformancePerTestCase, String configType, boolean modeOfThreshold, boolean failBuildIfNoResultFile, boolean compareBuildPrevious, List<PerformanceReportParser> parsers, boolean modeThroughput) {
        this.errorFailedThreshold = errorFailedThreshold;
        this.errorUnstableThreshold = errorUnstableThreshold;
        this.errorUnstableResponseTimeThreshold = errorUnstableResponseTimeThreshold;
        this.relativeFailedThresholdPositive = relativeFailedThresholdPositive;
        this.relativeFailedThresholdNegative = relativeFailedThresholdNegative;
        this.relativeUnstableThresholdPositive = relativeUnstableThresholdPositive;
        this.relativeUnstableThresholdNegative = relativeUnstableThresholdNegative;
        this.nthBuildNumber = nthBuildNumber;
        this.configType = configType;
        optionType = configType;
        this.modeOfThreshold = modeOfThreshold;
        this.failBuildIfNoResultFile = failBuildIfNoResultFile;
        this.compareBuildPrevious = compareBuildPrevious;
        if (parsers == null) {
            parsers = Collections.emptyList();
        }
        this.parsers = new ArrayList<PerformanceReportParser>(parsers);
        this.modePerformancePerTestCase = modePerformancePerTestCase;
        this.modeThroughput = modeThroughput;
    }

    public static File getPerformanceReport(Run<?, ?> build, String parserDisplayName, String performanceReportName) {
        return new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath(parserDisplayName, PerformancePublisher.getPerformanceReportBuildFileName(performanceReportName)));
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PerformanceProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public List<PerformanceReportParser> getParsers() {
        return this.parsers;
    }

    public static String getPerformanceReportBuildFileName(String performanceReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = performanceReportWorkspaceName;
        if (performanceReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(performanceReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    protected static List<FilePath> locatePerformanceReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            String[] parts2 = includes.split("\\s*[;:,]+\\s*");
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            for (String path : parts2) {
                FilePath[] ret = workspace.list(path);
                if (ret.length <= 0) continue;
                files.addAll(Arrays.asList(ret));
            }
            if (!files.isEmpty()) {
                return files;
            }
        }
        catch (IOException parts2) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/*")));
                continue;
            }
            files.add(src);
        }
        if (!files.isEmpty()) {
            return files;
        }
        File directFile = new File(includes);
        if (directFile.exists()) {
            files.add(new FilePath(directFile));
        }
        return files;
    }

    /*
     * WARNING - void declaration
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        double thresholdTolerance = 1.0E-8;
        Result result = Result.SUCCESS;
        run.setResult(Result.SUCCESS);
        EnvVars env = run.getEnvironment(listener);
        Collection<Object> parsedReports = Collections.emptyList();
        String glob = null;
        PerformanceBuildAction a = new PerformanceBuildAction(run, logger, this.parsers);
        run.addAction((Action)a);
        for (PerformanceReportParser performanceReportParser : this.parsers) {
            glob = performanceReportParser.glob;
            glob = env.expand(glob);
            logger.println("Performance: Recording " + performanceReportParser.getReportName() + " reports '" + glob + "'");
            List<FilePath> files = PerformancePublisher.locatePerformanceReports(workspace, glob);
            if (files.isEmpty()) {
                if (run.getResult().isWorseThan(Result.UNSTABLE)) {
                    return;
                }
                run.setResult(Result.FAILURE);
                logger.println("Performance: no " + performanceReportParser.getReportName() + " files matching '" + glob + "' have been found. Has the report generated?. Setting Build to " + run.getResult());
                return;
            }
            List<File> list = this.copyReportsToMaster(run, logger, files, performanceReportParser.getDescriptor().getDisplayName());
            parsedReports = performanceReportParser.parse(run, list, listener);
            if (performanceReportParser.reportURL == null || performanceReportParser.reportURL.isEmpty()) continue;
            run.addAction((Action)new ExternalBuildReport(performanceReportParser.reportURL));
        }
        for (PerformanceReport performanceReport : parsedReports) {
            performanceReport.setBuildAction(a);
        }
        if (!this.modeEvaluation) {
            if (!this.modeOfThreshold) {
                try {
                    List<UriReport> curruriList = null;
                    Object var14_18 = null;
                    if (!"".equals(this.errorUnstableResponseTimeThreshold) && this.errorUnstableResponseTimeThreshold != null) {
                        void var18_42;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String[] lines = this.errorUnstableResponseTimeThreshold.split("\n");
                        String[] stringArray = lines;
                        int n = stringArray.length;
                        boolean bl = false;
                        while (var18_42 < n) {
                            String line = stringArray[var18_42];
                            String[] components = line.split(":");
                            if (components.length == 2) {
                                logger.println("Setting threshold: " + components[0] + ":" + components[1]);
                                hashMap.put(components[0], components[1]);
                            }
                            ++var18_42;
                        }
                    }
                    if (this.errorUnstableThreshold >= 0 && this.errorUnstableThreshold <= 100) {
                        logger.println("Performance: Percentage of errors greater or equal than " + this.errorUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase());
                    } else {
                        logger.println("Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
                    }
                    if (this.errorFailedThreshold >= 0 && this.errorFailedThreshold <= 100) {
                        logger.println("Performance: Percentage of errors greater or equal than " + this.errorFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase());
                    } else {
                        logger.println("Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
                    }
                    for (PerformanceReportParser performanceReportParser : this.parsers) {
                        for (PerformanceReport performanceReport : parsedReports) {
                            void var14_20;
                            this.xmlDir = run.getRootDir().getAbsolutePath();
                            this.xmlDir = this.xmlDir + "/archive";
                            String[] arr = glob.split("/");
                            if (!new File(this.xmlDir).exists()) {
                                new File(this.xmlDir).mkdirs();
                            }
                            this.xmlfile = new File(this.xmlDir + "/dashBoard_" + arr[arr.length - 1].split("\\.")[0] + ".xml");
                            this.xmlfile.createNewFile();
                            FileWriter fw = new FileWriter(this.xmlfile.getAbsoluteFile());
                            BufferedWriter bw = new BufferedWriter(fw);
                            this.xml = "<?xml version=\"1.0\"?>\n";
                            this.xml = this.xml + "<results>\n";
                            this.xml = this.xml + "<absoluteDefinition>\n";
                            String unstable = "\t<unstable>";
                            String failed = "\t<failed>";
                            String calc = "\t<calculated>";
                            unstable = unstable + this.errorUnstableThreshold;
                            failed = failed + this.errorFailedThreshold;
                            String avg = "";
                            String med = "";
                            String perct = "";
                            avg = avg + "<average>\n";
                            med = med + "<median>\n";
                            perct = perct + "<percentile>\n";
                            double errorPercent = performanceReport.errorPercent();
                            calc = calc + errorPercent;
                            curruriList = performanceReport.getUriListOrdered();
                            if (this.errorFailedThreshold >= 0 && errorPercent - (double)this.errorFailedThreshold > thresholdTolerance) {
                                result = Result.FAILURE;
                                run.setResult(Result.FAILURE);
                            } else if (this.errorUnstableThreshold >= 0 && errorPercent - (double)this.errorUnstableThreshold > thresholdTolerance) {
                                result = Result.UNSTABLE;
                                run.setResult(Result.UNSTABLE);
                            }
                            long average = performanceReport.getAverage();
                            try {
                                if (var14_20 != null && var14_20.get(performanceReport.getReportFileName()) != null && Long.parseLong((String)var14_20.get(performanceReport.getReportFileName())) <= average) {
                                    logger.println("UNSTABLE: " + performanceReport.getReportFileName() + " has exceeded the threshold of [" + Long.parseLong((String)var14_20.get(performanceReport.getReportFileName())) + "] with the time of [" + Long.toString(average) + "]");
                                    result = Result.UNSTABLE;
                                }
                            }
                            catch (NumberFormatException nfe) {
                                logger.println("ERROR: Threshold set to a non-number [" + (String)var14_20.get(performanceReport.getReportFileName()) + "]");
                                result = Result.FAILURE;
                                run.setResult(Result.FAILURE);
                            }
                            if (result.isWorseThan(run.getResult())) {
                                run.setResult(result);
                            }
                            logger.println("Performance: File " + performanceReport.getReportFileName() + " reported " + errorPercent + "% of errors [" + result + "]. Build status is: " + run.getResult());
                            for (int i = 0; i < curruriList.size(); ++i) {
                                avg = avg + "\t<" + curruriList.get(i).getStaplerUri() + ">\n";
                                avg = avg + "\t\t<currentBuildAvg>" + curruriList.get(i).getAverage() + "</currentBuildAvg>\n";
                                avg = avg + "\t</" + curruriList.get(i).getStaplerUri() + ">\n";
                                med = med + "\t<" + curruriList.get(i).getStaplerUri() + ">\n";
                                med = med + "\t\t<currentBuildMed>" + curruriList.get(i).getMedian() + "</currentBuildMed>\n";
                                med = med + "\t</" + curruriList.get(i).getStaplerUri() + ">\n";
                                perct = perct + "\t<" + curruriList.get(i).getStaplerUri() + ">\n";
                                perct = perct + "\t\t<currentBuild90Line>" + curruriList.get(i).get90Line() + "</currentBuild90Line>\n";
                                perct = perct + "\t</" + curruriList.get(i).getStaplerUri() + ">\n";
                            }
                            unstable = unstable + "</unstable>";
                            failed = failed + "</failed>";
                            calc = calc + "</calculated>";
                            avg = avg + "</average>\n";
                            med = med + "</median>\n";
                            perct = perct + "</percentile>\n";
                            this.xml = this.xml + unstable + "\n";
                            this.xml = this.xml + failed + "\n";
                            this.xml = this.xml + calc + "\n";
                            this.xml = this.xml + "</absoluteDefinition>\n";
                            this.xml = this.xml + avg;
                            this.xml = this.xml + med;
                            this.xml = this.xml + perct;
                            this.xml = this.xml + "</results>";
                            bw.write(this.xml);
                            bw.close();
                            fw.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.println("ERROR: Exception while determining absolute error/unstable threshold evaluation");
                    e.printStackTrace(logger);
                }
            } else {
                try {
                    Run<?, ?> prevBuild;
                    String name = "";
                    Object var14_21 = null;
                    BufferedWriter bw = null;
                    String string = "<relativeDefinition>\n";
                    String unstable = "\t<unstable>\n";
                    String string2 = "\t<failed>\n";
                    String buildNo = "\t<buildNum>";
                    String inside = "";
                    String avg = "";
                    String med = "";
                    String perct = "";
                    unstable = unstable + "\t\t<negative>" + this.relativeUnstableThresholdNegative + "</negative>\n";
                    unstable = unstable + "\t\t<positive>" + this.relativeUnstableThresholdPositive + "</positive>\n";
                    String string4 = string2 + "\t\t<negative>" + this.relativeFailedThresholdNegative + "</negative>\n";
                    string4 = string4 + "\t\t<positive>" + this.relativeFailedThresholdPositive + "</positive>\n";
                    unstable = unstable + "\t</unstable>\n";
                    String string5 = string4 + "\t</failed>\n";
                    avg = avg + "<average>\n";
                    med = med + "<median>\n";
                    perct = perct + "<percentile>\n";
                    if (this.relativeFailedThresholdNegative <= 100.0 && this.relativeFailedThresholdPositive <= 100.0) {
                        logger.println("Performance: Percentage of relative difference outside -" + this.relativeFailedThresholdNegative + " to +" + this.relativeFailedThresholdPositive + " % sets the build as " + Result.FAILURE.toString().toLowerCase());
                    } else {
                        logger.println("Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
                    }
                    if (this.relativeUnstableThresholdNegative <= 100.0 && this.relativeUnstableThresholdPositive <= 100.0) {
                        logger.println("Performance: Percentage of relative difference outside -" + this.relativeUnstableThresholdNegative + " to +" + this.relativeUnstableThresholdPositive + " % sets the build as " + Result.UNSTABLE.toString().toLowerCase());
                    } else {
                        logger.println("Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
                    }
                    List<UriReport> curruriList = null;
                    for (PerformanceReportParser parser : this.parsers) {
                        Object localReports;
                        Iterator<Object> iterator;
                        glob = parser.glob;
                        name = glob = env.expand(glob);
                        List<FilePath> files = PerformancePublisher.locatePerformanceReports(workspace, glob);
                        if (files.isEmpty()) {
                            if (run.getResult().isWorseThan(Result.UNSTABLE)) {
                                return;
                            }
                            run.setResult(Result.FAILURE);
                            logger.println("Performance: no " + parser.getReportName() + " files matching '" + glob + "' have been found. Has the report generated?. Setting Build to " + run.getResult());
                        }
                        if (!(iterator = (parsedReports = parser.parse(run, (Collection<File>)(localReports = this.copyReportsToMaster(run, logger, files, parser.getDescriptor().getDisplayName())), listener)).iterator()).hasNext()) continue;
                        PerformanceReport r = (PerformanceReport)iterator.next();
                        curruriList = r.getUriListOrdered();
                    }
                    this.xmlDir = run.getRootDir().getAbsolutePath();
                    this.xmlDir = this.xmlDir + "/archive";
                    String[] arr = name.split("/");
                    if (!new File(this.xmlDir).exists()) {
                        new File(this.xmlDir).mkdirs();
                    }
                    this.xmlfile = new File(this.xmlDir + "/dashBoard_" + arr[arr.length - 1].split("\\.")[0] + ".xml");
                    this.xmlfile.createNewFile();
                    FileWriter fileWriter = new FileWriter(this.xmlfile.getAbsoluteFile());
                    bw = new BufferedWriter(fileWriter);
                    bw.write("<?xml version=\"1.0\"?>\n");
                    bw.write("<results>\n");
                    if (this.compareBuildPrevious) {
                        buildNo = buildNo + "previous";
                        prevBuild = run.getPreviousSuccessfulBuild();
                    } else {
                        buildNo = buildNo + this.nthBuildNumber;
                        prevBuild = this.getnthBuild(run);
                    }
                    buildNo = buildNo + "</buildNum>\n";
                    String string7 = string + buildNo + unstable + string5;
                    string7 = string7 + "</relativeDefinition>";
                    bw.write(string7 + "\n");
                    List<UriReport> prevuriList = null;
                    if (prevBuild != null) {
                        for (PerformanceReportParser parser : this.parsers) {
                            glob = parser.glob;
                            logger.println("Performance: Recording " + parser.getReportName() + " reports '" + glob + "'");
                            List<File> localReports = this.getExistingReports(prevBuild, logger, parser.getDescriptor().getDisplayName());
                            parsedReports = parser.parse(prevBuild, localReports, listener);
                            Iterator<Object> iterator = parsedReports.iterator();
                            if (!iterator.hasNext()) continue;
                            PerformanceReport r = (PerformanceReport)iterator.next();
                            prevuriList = r.getUriListOrdered();
                        }
                        result = Result.SUCCESS;
                        String failedLabel = null;
                        String unStableLabel = null;
                        double relativeDiff = 0.0;
                        double relativeDiffPercent = 0.0;
                        logger.print("\nComparison build no. - " + prevBuild.number + " and " + run.number + " using ");
                        if (this.configType.equalsIgnoreCase(ART)) {
                            logger.println("Average response time\n\n");
                            logger.println("====================================================================================================================================");
                            logger.println("PrevBuildURI\tCurrentBuildURI\t\tPrevBuildURIAvg\t\tCurrentBuildURIAvg\tRelativeDiff\tRelativeDiffPercentage ");
                            logger.println("====================================================================================================================================");
                        } else if (this.configType.equalsIgnoreCase(MRT)) {
                            logger.println("Median response time\n\n");
                            logger.println("====================================================================================================================================");
                            logger.println("PrevBuildURI\tCurrentBuildURI\t\tPrevBuildURIMed\t\tCurrentBuildURIMed\tRelativeDiff\tRelativeDiffPercentage ");
                            logger.println("====================================================================================================================================");
                        } else if (this.configType.equalsIgnoreCase(PRT)) {
                            logger.println("90 Percentile response time\n\n");
                            logger.println("====================================================================================================================================");
                            logger.println("PrevBuildURI\tCurrentBuildURI\t\tPrevBuildURI90%\t\tCurrentBuildURI90%\tRelativeDiff\tRelativeDiffPercentage ");
                            logger.println("====================================================================================================================================");
                        }
                        for (int i = 0; i < prevuriList.size(); ++i) {
                            for (int j = 0; j < curruriList.size(); ++j) {
                                if (!prevuriList.get(i).getStaplerUri().equalsIgnoreCase(curruriList.get(j).getStaplerUri())) continue;
                                relativeDiff = curruriList.get(j).getAverage() - prevuriList.get(i).getAverage();
                                relativeDiffPercent = relativeDiff * 100.0 / (double)prevuriList.get(i).getAverage();
                                relativeDiffPercent = Math.round(relativeDiffPercent * 100.0);
                                avg = avg + "\t<" + curruriList.get(j).getStaplerUri() + ">\n";
                                avg = avg + "\t\t<previousBuildAvg>" + prevuriList.get(i).getAverage() + "</previousBuildAvg>\n";
                                avg = avg + "\t\t<currentBuildAvg>" + curruriList.get(j).getAverage() + "</currentBuildAvg>\n";
                                avg = avg + "\t\t<relativeDiff>" + relativeDiff + "</relativeDiff>\n";
                                avg = avg + "\t\t<relativeDiffPercent>" + (relativeDiffPercent /= 100.0) + "</relativeDiffPercent>\n";
                                avg = avg + "\t</" + curruriList.get(j).getStaplerUri() + ">\n";
                                relativeDiff = curruriList.get(j).getMedian() - prevuriList.get(i).getMedian();
                                relativeDiffPercent = relativeDiff * 100.0 / (double)prevuriList.get(i).getMedian();
                                relativeDiffPercent = Math.round(relativeDiffPercent * 100.0);
                                med = med + "\t<" + curruriList.get(j).getStaplerUri() + ">\n";
                                med = med + "\t\t<previousBuildMed>" + prevuriList.get(i).getMedian() + "</previousBuildMed>\n";
                                med = med + "\t\t<currentBuildMed>" + curruriList.get(j).getMedian() + "</currentBuildMed>\n";
                                med = med + "\t\t<relativeDiff>" + relativeDiff + "</relativeDiff>\n";
                                med = med + "\t\t<relativeDiffPercent>" + (relativeDiffPercent /= 100.0) + "</relativeDiffPercent>\n";
                                med = med + "\t</" + curruriList.get(j).getStaplerUri() + ">\n";
                                relativeDiff = curruriList.get(j).get90Line() - prevuriList.get(i).get90Line();
                                relativeDiffPercent = relativeDiff * 100.0 / (double)prevuriList.get(i).get90Line();
                                relativeDiffPercent = Math.round(relativeDiffPercent * 100.0);
                                perct = perct + "\t<" + curruriList.get(j).getStaplerUri() + ">\n";
                                perct = perct + "\t\t<previousBuild90Line>" + prevuriList.get(i).get90Line() + "</previousBuild90Line>\n";
                                perct = perct + "\t\t<currentBuild90Line>" + curruriList.get(j).get90Line() + "</currentBuild90Line>\n";
                                perct = perct + "\t\t<relativeDiff>" + relativeDiff + "</relativeDiff>\n";
                                perct = perct + "\t\t<relativeDiffPercent>" + (relativeDiffPercent /= 100.0) + "</relativeDiffPercent>\n";
                                perct = perct + "\t</" + curruriList.get(j).getStaplerUri() + ">\n";
                                if (this.configType.equalsIgnoreCase(ART)) {
                                    relativeDiff = curruriList.get(j).getAverage() - prevuriList.get(i).getAverage();
                                    relativeDiffPercent = relativeDiff * 100.0 / (double)prevuriList.get(i).getAverage();
                                    relativeDiffPercent = Math.round(relativeDiffPercent * 100.0);
                                    logger.println(prevuriList.get(i).getStaplerUri() + "\t" + curruriList.get(j).getStaplerUri() + "\t\t" + prevuriList.get(i).getAverage() + "\t\t\t" + curruriList.get(j).getAverage() + "\t\t\t" + relativeDiff + "\t\t" + (relativeDiffPercent /= 100.0));
                                } else if (this.configType.equalsIgnoreCase(MRT)) {
                                    relativeDiff = curruriList.get(j).getMedian() - prevuriList.get(i).getMedian();
                                    relativeDiffPercent = relativeDiff * 100.0 / (double)prevuriList.get(i).getMedian();
                                    relativeDiffPercent = Math.round(relativeDiffPercent * 100.0);
                                    logger.println(prevuriList.get(i).getStaplerUri() + "\t" + curruriList.get(j).getStaplerUri() + "\t\t" + prevuriList.get(i).getMedian() + "\t\t\t" + curruriList.get(j).getMedian() + "\t\t\t" + relativeDiff + "\t\t" + (relativeDiffPercent /= 100.0));
                                } else if (this.configType.equalsIgnoreCase(PRT)) {
                                    relativeDiff = curruriList.get(j).get90Line() - prevuriList.get(i).get90Line();
                                    relativeDiffPercent = relativeDiff * 100.0 / (double)prevuriList.get(i).get90Line();
                                    relativeDiffPercent = Math.round(relativeDiffPercent * 100.0);
                                    logger.println(prevuriList.get(i).getStaplerUri() + "\t" + curruriList.get(j).getStaplerUri() + "\t\t" + prevuriList.get(i).get90Line() + "\t\t\t" + curruriList.get(j).get90Line() + "\t\t\t" + relativeDiff + "\t\t" + (relativeDiffPercent /= 100.0));
                                }
                                if (relativeDiffPercent < 0.0) {
                                    if (this.relativeFailedThresholdNegative >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeFailedThresholdNegative > thresholdTolerance) {
                                        result = Result.FAILURE;
                                        run.setResult(Result.FAILURE);
                                        failedLabel = prevuriList.get(i).getStaplerUri();
                                    } else if (this.relativeUnstableThresholdNegative >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeUnstableThresholdNegative > thresholdTolerance) {
                                        result = Result.UNSTABLE;
                                        run.setResult(Result.UNSTABLE);
                                        unStableLabel = prevuriList.get(i).getStaplerUri();
                                    }
                                } else if (relativeDiffPercent >= 0.0) {
                                    if (this.relativeFailedThresholdPositive >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeFailedThresholdPositive > thresholdTolerance) {
                                        result = Result.FAILURE;
                                        run.setResult(Result.FAILURE);
                                        failedLabel = prevuriList.get(i).getStaplerUri();
                                    } else if (this.relativeUnstableThresholdPositive >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeUnstableThresholdPositive > thresholdTolerance) {
                                        result = Result.UNSTABLE;
                                        run.setResult(Result.UNSTABLE);
                                        unStableLabel = prevuriList.get(i).getStaplerUri();
                                    }
                                }
                                if (!result.isWorseThan(run.getResult())) continue;
                                run.setResult(result);
                            }
                        }
                        logger.println("------------------------------------------------------------------------------------------------------------------------------------");
                        String labelResult = "\nThe label ";
                        logger.print(failedLabel != null ? labelResult + "\"" + failedLabel + "\" caused the build to fail\n" : (unStableLabel != null ? labelResult + "\"" + unStableLabel + "\" made the build unstable\n" : ""));
                        avg = avg + "</average>\n";
                        med = med + "</median>\n";
                        perct = perct + "</percentile>";
                        inside = inside + avg + med + perct;
                        bw.write(inside + "\n");
                    }
                    bw.write("</results>");
                    bw.close();
                    fileWriter.close();
                }
                catch (Exception e) {
                    logger.println("ERROR: Exception while determining relative comparison between builds");
                    e.printStackTrace(logger);
                }
            }
        } else {
            void var16_35;
            ConstraintFactory factory = new ConstraintFactory();
            ConstraintSettings constraintSettings = new ConstraintSettings((BuildListener)listener, this.ignoreFailedBuilds, this.ignoreUnstableBuilds, this.persistConstraintLog);
            ConstraintChecker checker = new ConstraintChecker(constraintSettings, (List<? extends Run<?, ?>>)run.getParent().getBuilds());
            ArrayList arrayList = new ArrayList();
            try {
                ArrayList<ConstraintEvaluation> arrayList2 = checker.checkAllConstraints(factory.createConstraintClones(run, this.constraints));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ConstraintReport cr = new ConstraintReport((ArrayList<ConstraintEvaluation>)var16_35, run.getParent().getBuilds().get(0), this.persistConstraintLog);
            logger.print(cr.getLoggerMsg());
            run.setResult(cr.getBuildResult());
        }
    }

    private List<File> copyReportsToMaster(Run<?, ?> build, PrintStream logger, List<FilePath> files, String parserDisplayName) throws IOException, InterruptedException {
        ArrayList<File> localReports = new ArrayList<File>();
        for (FilePath src : files) {
            File localReport = PerformancePublisher.getPerformanceReport(build, parserDisplayName, src.getName());
            if (src.isDirectory()) {
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
                continue;
            }
            src.copyTo(new FilePath(localReport));
            localReports.add(localReport);
        }
        return localReports;
    }

    public Object readResolve() {
        if (this.parsers == null) {
            this.parsers = new ArrayList<PerformanceReportParser>();
        }
        if (this.filename != null) {
            this.parsers.add(new JMeterParser(this.filename));
            this.filename = null;
        }
        return this;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getErrorUnstableResponseTimeThreshold() {
        return this.errorUnstableResponseTimeThreshold;
    }

    public void setErrorUnstableResponseTimeThreshold(String errorUnstableResponseTimeThreshold) {
        this.errorUnstableResponseTimeThreshold = errorUnstableResponseTimeThreshold;
    }

    public boolean isModePerformancePerTestCase() {
        return this.modePerformancePerTestCase;
    }

    public void setModePerformancePerTestCase(boolean modePerformancePerTestCase) {
        this.modePerformancePerTestCase = modePerformancePerTestCase;
    }

    public boolean getModePerformancePerTestCase() {
        return this.modePerformancePerTestCase;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isFailBuildIfNoResultFile() {
        return this.failBuildIfNoResultFile;
    }

    public void setFailBuildIfNoResultFile(boolean failBuildIfNoResultFile) {
        this.failBuildIfNoResultFile = failBuildIfNoResultFile;
    }

    public boolean isART() {
        return this.configType.compareToIgnoreCase(ART) == 0;
    }

    public boolean isMRT() {
        return this.configType.compareToIgnoreCase(MRT) == 0;
    }

    public boolean isPRT() {
        return this.configType.compareToIgnoreCase(PRT) == 0;
    }

    public static File[] getPerformanceReportDirectory(Run<?, ?> build, String parserDisplayName, PrintStream logger) {
        File folder = new File(build.getRootDir() + "/" + PerformanceReportMap.getPerformanceReportFileRelativePath(parserDisplayName, ""));
        return folder.listFiles();
    }

    public Run<?, ?> getnthBuild(Run<?, ?> build) throws IOException {
        Run nthBuild = build;
        int nextBuildNumber = build.number - this.nthBuildNumber;
        for (int i = 1; i <= nextBuildNumber; ++i) {
            if ((nthBuild = nthBuild.getPreviousBuild()) != null) continue;
            return null;
        }
        return this.nthBuildNumber == 0 ? null : nthBuild;
    }

    private List<File> getExistingReports(Run<?, ?> build, PrintStream logger, String parserDisplayName) throws IOException, InterruptedException {
        ArrayList<File> localReports = new ArrayList<File>();
        File[] localReport = PerformancePublisher.getPerformanceReportDirectory(build, parserDisplayName, logger);
        for (int i = 0; i < localReport.length; ++i) {
            String name = localReport[i].getName();
            String[] arr = name.split("\\.");
            if (arr[arr.length - 1].equalsIgnoreCase("serialized")) continue;
            localReports.add(localReport[i]);
        }
        return localReports;
    }

    public static String getOptionType() {
        return optionType;
    }

    public double getRelativeFailedThresholdPositive() {
        return this.relativeFailedThresholdPositive;
    }

    public double getRelativeFailedThresholdNegative() {
        return this.relativeFailedThresholdNegative;
    }

    public void setRelativeFailedThresholdPositive(double relativeFailedThresholdPositive) {
        this.relativeFailedThresholdPositive = Math.max(0.0, Math.min(relativeFailedThresholdPositive, 100.0));
    }

    public void setRelativeFailedThresholdNegative(double relativeFailedThresholdNegative) {
        this.relativeFailedThresholdNegative = Math.max(0.0, Math.min(relativeFailedThresholdNegative, 100.0));
    }

    public double getRelativeUnstableThresholdPositive() {
        return this.relativeUnstableThresholdPositive;
    }

    public double getRelativeUnstableThresholdNegative() {
        return this.relativeUnstableThresholdNegative;
    }

    public void setRelativeUnstableThresholdPositive(double relativeUnstableThresholdPositive) {
        this.relativeUnstableThresholdPositive = Math.max(0.0, Math.min(relativeUnstableThresholdPositive, 100.0));
    }

    public void setRelativeUnstableThresholdNegative(double relativeUnstableThresholdNegative) {
        this.relativeUnstableThresholdNegative = Math.max(0.0, Math.min(relativeUnstableThresholdNegative, 100.0));
    }

    public int getNthBuildNumber() {
        return this.nthBuildNumber;
    }

    public void setNthBuildNumber(int nthBuildNumber) {
        this.nthBuildNumber = Math.max(0, Math.min(nthBuildNumber, Integer.MAX_VALUE));
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public boolean getModeOfThreshold() {
        return this.modeOfThreshold;
    }

    public void setModeOfThreshold(boolean modeOfThreshold) {
        this.modeOfThreshold = modeOfThreshold;
    }

    public boolean getCompareBuildPrevious() {
        return this.compareBuildPrevious;
    }

    public void setCompareBuildPrevious(boolean compareBuildPrevious) {
        this.compareBuildPrevious = compareBuildPrevious;
    }

    public void setModeRelativeThresholds(boolean modeRelativeThresholds) {
        this.modeRelativeThresholds = modeRelativeThresholds;
    }

    public boolean getModeRelativeThresholds() {
        return this.modeRelativeThresholds;
    }

    public boolean isModeThroughput() {
        return this.modeThroughput;
    }

    public void setModeThroughput(boolean modeThroughput) {
        this.modeThroughput = modeThroughput;
    }

    public List<? extends AbstractConstraint> getConstraints() {
        return this.constraints;
    }

    @DataBoundSetter
    public void setConstraints(List<? extends AbstractConstraint> constraints) {
        this.constraints = constraints;
    }

    @DataBoundSetter
    public void setIgnoreFailedBuilds(boolean ignoreFailedBuilds) {
        this.ignoreFailedBuilds = ignoreFailedBuilds;
    }

    public boolean isIgnoreFailedBuilds() {
        return this.ignoreFailedBuilds;
    }

    @DataBoundSetter
    public void setIgnoreUnstableBuilds(boolean ignoreUnstableBuilds) {
        this.ignoreUnstableBuilds = ignoreUnstableBuilds;
    }

    public boolean isIgnoreUnstableBuilds() {
        return this.ignoreUnstableBuilds;
    }

    public boolean isPersistConstraintLog() {
        return this.persistConstraintLog;
    }

    @DataBoundSetter
    public void setPersistConstraintLog(boolean persistConstraintLog) {
        this.persistConstraintLog = persistConstraintLog;
    }

    public boolean isModeEvaluation() {
        return this.modeEvaluation;
    }

    @DataBoundSetter
    public void setModeEvaluation(boolean modeEvaluation) {
        this.modeEvaluation = modeEvaluation;
    }

    @Symbol(value={"performanceReport"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.Publisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/performance/help.html";
        }

        public List<PerformanceReportParserDescriptor> getParserDescriptors() {
            return PerformanceReportParserDescriptor.all();
        }

        public List<ConstraintDescriptor> getConstraintDescriptors() {
            return ConstraintDescriptor.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillConfigTypeItems() {
            ListBoxModel items = new ListBoxModel();
            String temp = PerformancePublisher.getOptionType();
            if (temp.equalsIgnoreCase(PerformancePublisher.ART)) {
                items.add("Average Response Time", PerformancePublisher.ART);
                items.add("Median Response Time", PerformancePublisher.MRT);
                items.add("Percentile Response Time", PerformancePublisher.PRT);
            } else if (temp.equalsIgnoreCase(PerformancePublisher.MRT)) {
                items.add("Median Response Time", PerformancePublisher.MRT);
                items.add("Percentile Response Time", PerformancePublisher.PRT);
                items.add("Average Response Time", PerformancePublisher.ART);
            } else if (temp.equalsIgnoreCase(PerformancePublisher.PRT)) {
                items.add("Percentile Response Time", PerformancePublisher.PRT);
                items.add("Average Response Time", PerformancePublisher.ART);
                items.add("Median Response Time", PerformancePublisher.MRT);
            }
            return items;
        }
    }
}

