/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports;

import hudson.plugins.performance.data.HttpSample;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;

public abstract class AbstractReport {
    public static final Logger LOGGER = Logger.getLogger(AbstractReport.class.getName());
    public static final double ZERO_PERCENT = 0.0;
    public static final double ONE_HUNDRED_PERCENT = 100.0;
    public static final double NINETY_PERCENT = 90.0;
    public static final double NINETY_FIVE_PERCENT = 95.0;
    public static final double FIFTY_PERCENT = 50.0;
    public static final String DEFAULT_PERCENTILES = "0,50,90,95,100";
    protected final ThreadLocal<DecimalFormat> percentFormat;
    protected final ThreadLocal<DecimalFormat> dataFormat;
    protected Map<Double, Long> percentilesValues = new TreeMap<Double, Long>();
    protected Map<Double, Long> percentilesDiffValues = new TreeMap<Double, Long>();
    protected boolean isCalculatedPercentilesValues = false;
    protected boolean excludeResponseTime;
    protected boolean showTrendGraphs;

    public abstract int countErrors();

    public abstract double errorPercent();

    public abstract void calculatePercentiles();

    public abstract void calculateDiffPercentiles();

    public AbstractReport() {
        final Locale useThisLocale = Stapler.getCurrentRequest() != null ? Stapler.getCurrentRequest().getLocale() : Locale.getDefault();
        this.percentFormat = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(useThisLocale));
            }
        };
        this.dataFormat = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(useThisLocale));
            }
        };
    }

    public String errorPercentFormated() {
        Stapler.getCurrentRequest().getLocale();
        return this.percentFormat.get().format(this.errorPercent());
    }

    protected void checkPercentileAndSet(Double key, Long value) {
        if (value != null) {
            this.percentilesValues.put(key, value);
            this.isCalculatedPercentilesValues = true;
        }
    }

    protected List<Double> parsePercentiles(String percentiles) {
        ArrayList<Double> res = new ArrayList<Double>();
        if (!StringUtils.isBlank((String)percentiles)) {
            String[] percs;
            for (String perc : percs = percentiles.split(",")) {
                try {
                    res.add(Double.parseDouble(perc));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.WARNING, "Cannot parse percentile value " + perc);
                }
            }
        }
        return res;
    }

    public abstract long getAverage();

    public String getAverageFormated() {
        return this.dataFormat.get().format(this.getAverage());
    }

    public abstract long getMedian();

    public String getMeanFormated() {
        return this.dataFormat.get().format(this.getMedian());
    }

    public abstract long get90Line();

    public String get90LineFormated() {
        return this.dataFormat.get().format(this.get90Line());
    }

    public abstract long get95Line();

    public String get95LineFormated() {
        return this.dataFormat.get().format(this.get95Line());
    }

    public abstract long getMax();

    public String getMaxFormated() {
        return this.dataFormat.get().format(this.getMax());
    }

    public abstract long getMin();

    public abstract int samplesCount();

    public abstract String getHttpCode();

    public abstract long getAverageDiff();

    public abstract long getMedianDiff();

    public abstract long get90LineDiff();

    public abstract long get95LineDiff();

    public abstract double getErrorPercentDiff();

    public abstract String getLastBuildHttpCodeIfChanged();

    public abstract int getSamplesCountDiff();

    public boolean isExcludeResponseTime() {
        return this.excludeResponseTime;
    }

    public void setExcludeResponseTime(boolean excludeResponseTime) {
        this.excludeResponseTime = excludeResponseTime;
    }

    public boolean isShowTrendGraphs() {
        return this.showTrendGraphs;
    }

    public void setShowTrendGraphs(boolean showTrendGraphs) {
        this.showTrendGraphs = showTrendGraphs;
    }

    protected boolean isIncludeResponseTime(HttpSample sample) {
        return !sample.isFailed() || !this.excludeResponseTime || sample.isSummarizer();
    }

    public Map<Double, Long> getPercentilesValues() {
        if (!this.isCalculatedPercentilesValues) {
            this.calculatePercentiles();
            this.calculateDiffPercentiles();
        }
        return this.percentilesValues;
    }

    public Map<Double, Long> getPercentilesDiffValues() {
        if (!this.isCalculatedPercentilesValues) {
            this.calculatePercentiles();
            this.calculateDiffPercentiles();
        }
        return this.percentilesDiffValues;
    }

    public String getPercentileLabel(Double perc) {
        if (perc == 0.0) {
            return "Min(ms)";
        }
        if (perc == 50.0) {
            return "Median(ms)";
        }
        if (perc == 100.0) {
            return "Max(ms)";
        }
        return "Line " + perc + "(ms)";
    }
}

