/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterCsvParser
extends PerformanceReportParser {
    private final boolean skipFirstLine;
    private final String delimiter;
    private int timestampIdx = -1;
    private int elapsedIdx = -1;
    private int responseCodeIdx = -1;
    private int successIdx = -1;
    private int urlIdx = -1;

    @DataBoundConstructor
    public JMeterCsvParser(String glob, String pattern, String delimiter, Boolean skipFirstLine) throws Exception {
        super(glob);
        this.skipFirstLine = skipFirstLine;
        this.delimiter = delimiter;
        String[] fields = pattern.split(delimiter);
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if ("timestamp".equals(field)) {
                this.timestampIdx = i;
                continue;
            }
            if ("elapsed".equals(field)) {
                this.elapsedIdx = i;
                continue;
            }
            if ("responseCode".equals(field)) {
                this.responseCodeIdx = i;
                continue;
            }
            if ("success".equals(field)) {
                this.successIdx = i;
                continue;
            }
            if (!"URL".equals(field)) continue;
            this.urlIdx = i;
        }
        if (this.timestampIdx < 0 || this.elapsedIdx < 0 || this.responseCodeIdx < 0 || this.successIdx < 0 || this.urlIdx < 0) {
            throw new Exception("Missing required column");
        }
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        PrintStream logger = listener.getLogger();
        for (File f : reports) {
            PerformanceReport r = new PerformanceReport();
            r.setReportFileName(f.getName());
            logger.println("Performance: Parsing JMeter report file " + f.getName());
            BufferedReader reader = new BufferedReader(new FileReader(f));
            try {
                String line = reader.readLine();
                if (line != null && this.skipFirstLine) {
                    logger.println("Performance: Skipping first line");
                    line = reader.readLine();
                }
                while (line != null) {
                    HttpSample sample = this.getSample(line);
                    if (sample != null) {
                        try {
                            r.addSample(sample);
                        }
                        catch (SAXException e) {
                            throw new RuntimeException("Unnable to add sample for line " + line, e);
                        }
                    }
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            result.add(r);
        }
        return result;
    }

    private HttpSample getSample(String line) {
        HttpSample sample = new HttpSample();
        String commasNotInsideQuotes = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
        String[] values = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        sample.setDate(new Date(Long.valueOf(values[this.timestampIdx])));
        sample.setDuration(Long.valueOf(values[this.elapsedIdx]));
        sample.setHttpCode(values[this.responseCodeIdx]);
        sample.setSuccessful(Boolean.valueOf(values[this.successIdx]));
        sample.setUri(values[this.urlIdx]);
        return sample;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeterCSV";
        }

        public FormValidation doCheckDelimiter(@QueryParameter String delimiter) {
            if (delimiter == null || delimiter.isEmpty()) {
                return FormValidation.error((String)Messages.CsvParser_validation_delimiterEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPattern(@QueryParameter String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                FormValidation.error((String)Messages.CsvParser_validation_patternEmpty());
            }
            HashSet<String> missing = new HashSet<String>();
            this.validatePresent(missing, pattern, "timestamp");
            this.validatePresent(missing, pattern, "elapsed");
            this.validatePresent(missing, pattern, "responseCode");
            this.validatePresent(missing, pattern, "success");
            this.validatePresent(missing, pattern, "URL");
            if (missing.isEmpty()) {
                return FormValidation.ok();
            }
            StringBuilder builder = new StringBuilder();
            for (String field : missing) {
                builder.append(field + ", ");
            }
            builder.setLength(builder.length() - 2);
            return FormValidation.error((String)(Messages.CsvParser_validation_MissingFields() + ": " + builder.toString()));
        }

        private void validatePresent(Set<String> missing, String pattern, String string) {
            if (!pattern.contains(string)) {
                missing.add(string);
            }
        }
    }
}

