/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.plugins.performance.AbstractReport;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.UriReport;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class PerformanceReport
extends AbstractReport
implements Serializable,
Comparable<PerformanceReport> {
    private static final long serialVersionUID = 675698410989941826L;
    private static final double ZERO_PERCENT = 0.0;
    private static final double ONE_HUNDRED_PERCENT = 100.0;
    private static final double NINETY_PERCENT = 90.0;
    private static final double FIFTY_PERCENT = 50.0;
    private transient PerformanceBuildAction buildAction;
    private String reportFileName = null;
    private final Map<String, UriReport> uriReportMap = new LinkedHashMap<String, UriReport>();
    private PerformanceReport lastBuildReport;
    private transient List<Long> durationsSortedBySize = null;
    private transient List<UriReport> uriReportsOrdered = null;
    private int nbError = 0;
    private float summarizerErrors = 0.0f;
    private int size;
    private long totalDuration = 0L;
    private double totalSizeInKB = 0.0;
    private long summarizerMin;
    private long summarizerMax;
    private long summarizerAvg;
    private String summarizerErrorPercent = null;
    private long summarizerSize;

    public static String asStaplerURI(String uri) {
        return uri.replace("http:", "").replaceAll("/", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        String staplerUri = PerformanceReport.asStaplerURI(uri);
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            UriReport uriReport = this.uriReportMap.get(staplerUri);
            if (uriReport == null) {
                uriReport = new UriReport(this, staplerUri, uri);
                this.uriReportMap.put(staplerUri, uriReport);
            }
            uriReport.addHttpSample(pHttpSample);
            this.durationsSortedBySize = null;
            this.uriReportsOrdered = null;
        }
        if (!pHttpSample.isSuccessful()) {
            ++this.nbError;
        }
        this.summarizerErrors += pHttpSample.getSummarizerErrors();
        ++this.size;
        this.totalDuration += pHttpSample.getDuration();
        this.totalSizeInKB += pHttpSample.getSizeInKb();
    }

    @Override
    public int compareTo(PerformanceReport jmReport) {
        if (this == jmReport) {
            return 0;
        }
        return this.getReportFileName().compareTo(jmReport.getReportFileName());
    }

    @Override
    public int countErrors() {
        return this.nbError;
    }

    @Override
    public double errorPercent() {
        if (this.ifSummarizerParserUsed(this.reportFileName)) {
            if (this.uriReportMap.size() == 0) {
                return 0.0;
            }
            return this.summarizerErrors / (float)this.uriReportMap.size();
        }
        return this.size() == 0 ? 0.0 : (double)this.countErrors() / (double)this.size() * 100.0;
    }

    @Override
    public long getAverage() {
        if (this.size == 0) {
            return 0L;
        }
        return this.totalDuration / (long)this.size;
    }

    public double getAverageSizeInKb() {
        if (this.size == 0) {
            return 0.0;
        }
        return this.roundTwoDecimals(this.totalSizeInKB / (double)this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDurationAt(double percentage) {
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("Argument 'percentage' must be a value between 0 and 100 (inclusive)");
        }
        if (this.size == 0) {
            return 0L;
        }
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.durationsSortedBySize == null) {
                this.durationsSortedBySize = new ArrayList<Long>();
                for (UriReport currentReport : this.uriReportMap.values()) {
                    this.durationsSortedBySize.addAll(currentReport.getDurations());
                }
                Collections.sort(this.durationsSortedBySize);
            }
            double percentInDecimals = percentage / 100.0;
            int indexToReturn = (int)((double)this.durationsSortedBySize.size() * percentInDecimals) - 1;
            if (indexToReturn < 0) {
                indexToReturn = 0;
            } else if (indexToReturn >= this.durationsSortedBySize.size()) {
                indexToReturn = this.durationsSortedBySize.size() - 1;
            }
            return this.durationsSortedBySize.get(indexToReturn);
        }
    }

    @Override
    public long get90Line() {
        return this.getDurationAt(90.0);
    }

    @Override
    public long getMedian() {
        return this.getDurationAt(50.0);
    }

    @Override
    public String getHttpCode() {
        return "";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public UriReport getDynamic(String token) throws IOException {
        return this.getUriReportMap().get(token);
    }

    @Override
    public long getMax() {
        return this.getDurationAt(100.0);
    }

    public double getTotalTrafficInKb() {
        return this.roundTwoDecimals(this.totalSizeInKB);
    }

    @Override
    public long getMin() {
        return this.getDurationAt(0.0);
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UriReport> getUriListOrdered() {
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.uriReportsOrdered == null) {
                this.uriReportsOrdered = new ArrayList<UriReport>(this.uriReportMap.values());
                Collections.sort(this.uriReportsOrdered, Collections.reverseOrder());
            }
            return this.uriReportsOrdered;
        }
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void setLastBuildReport(PerformanceReport lastBuildReport) {
        Map<String, UriReport> lastBuildUriReportMap = lastBuildReport.getUriReportMap();
        for (Map.Entry<String, UriReport> item : this.uriReportMap.entrySet()) {
            UriReport lastBuildUri = lastBuildUriReportMap.get(item.getKey());
            if (lastBuildUri == null) continue;
            item.getValue().addLastBuildUriReport(lastBuildUri);
        }
        this.lastBuildReport = lastBuildReport;
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildReport.getMedian();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildReport == null) {
            return 0.0;
        }
        return this.errorPercent() - this.lastBuildReport.errorPercent();
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        return "";
    }

    @Override
    public int getSizeDiff() {
        if (this.lastBuildReport == null) {
            return 0;
        }
        return this.size() - this.lastBuildReport.size();
    }

    public boolean ifSummarizerParserUsed(String filename) {
        PerformanceReportParser parser = this.buildAction.getParserByDisplayName("JmeterSummarizer");
        if (parser != null) {
            String[] parts;
            String fileExt = parser.glob;
            for (String path : parts = fileExt.split("\\s*[;:,]+\\s*")) {
                if (!filename.endsWith(path.substring(5))) continue;
                return true;
            }
        }
        return (parser = this.buildAction.getParserByDisplayName("Iago")) != null;
    }

    private double roundTwoDecimals(double d) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public void setSummarizerSize(long summarizerSize) {
        this.summarizerSize = summarizerSize;
    }

    public long getSummarizerSize() {
        return this.summarizerSize;
    }

    public void setSummarizerMin(long summarizerMin) {
        this.summarizerMin = summarizerMin;
    }

    public long getSummarizerMin() {
        return this.summarizerMin;
    }

    public void setSummarizerMax(long summarizerMax) {
        this.summarizerMax = summarizerMax;
    }

    public long getSummarizerMax() {
        return this.summarizerMax;
    }

    public void setSummarizerAvg(long summarizerAvg) {
        this.summarizerAvg = summarizerAvg;
    }

    public long getSummarizerAvg() {
        return this.summarizerAvg;
    }

    public void setSummarizerErrors(String summarizerErrorPercent) {
        this.summarizerErrorPercent = summarizerErrorPercent;
    }

    public String getSummarizerErrors() {
        return this.summarizerErrorPercent;
    }
}

