/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.JMeterParser;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParser
extends PerformanceReportParser {
    private static final Logger LOGGER = Logger.getLogger(JMeterParser.class.getName());
    private static final String SERIALIZED_DATA_FILE_SUFFIX = ".serialized";
    private static final Cache<String, PerformanceReport> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public AbstractParser(String glob) {
        super(glob);
    }

    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        for (File reportFile : reports) {
            PerformanceReport deserializedReport = AbstractParser.loadSerializedReport(reportFile);
            if (deserializedReport != null) {
                result.add(deserializedReport);
                continue;
            }
            try {
                listener.getLogger().println("Performance: Parsing JMeter report file '" + reportFile + "'.");
                PerformanceReport report = this.parse(reportFile);
                result.add(report);
                AbstractParser.saveSerializedReport(reportFile, report);
            }
            catch (Throwable e) {
                listener.getLogger().println("Performance: Failed to parse file '" + reportFile + "': " + e.getMessage());
                e.printStackTrace(listener.getLogger());
            }
        }
        return result;
    }

    abstract PerformanceReport parse(File var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static PerformanceReport loadSerializedReport(File reportFile) {
        if (reportFile == null) {
            throw new NullPointerException("Argument 'reportFile' cannot be null.");
        }
        String serialized = reportFile.getPath() + SERIALIZED_DATA_FILE_SUFFIX;
        ObjectInputStream in = null;
        Cache<String, PerformanceReport> cache = CACHE;
        synchronized (cache) {
            try {
                PerformanceReport report = (PerformanceReport)CACHE.getIfPresent((Object)serialized);
                if (report == null) {
                    in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(serialized)));
                    report = (PerformanceReport)in.readObject();
                    CACHE.put((Object)serialized, (Object)report);
                }
                PerformanceReport performanceReport = report;
                return performanceReport;
            }
            catch (FileNotFoundException ex) {
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Reading serialized PerformanceReport instance from file '" + serialized + "' failed.", ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Unable to close inputstream after attempt to read data from file '" + serialized + "'.", ex);
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveSerializedReport(File reportFile, PerformanceReport report) {
        if (reportFile == null) {
            throw new NullPointerException("Argument 'reportFile' cannot be null.");
        }
        if (report == null) {
            throw new NullPointerException("Argument 'report' cannot be null.");
        }
        String serialized = reportFile.getPath() + SERIALIZED_DATA_FILE_SUFFIX;
        Cache<String, PerformanceReport> cache = CACHE;
        synchronized (cache) {
            CACHE.put((Object)serialized, (Object)report);
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serialized)));
            out.writeObject(report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Saving serialized PerformanceReport instance to file '" + serialized + "' failed.", ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Unable to close outputstream after attempt to write data to file '" + serialized + "'.", ex);
                }
            }
        }
    }
}

