/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.JMeterParser;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitParser
extends JMeterParser {
    @DataBoundConstructor
    public JUnitParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/TEST-*.xml";
    }

    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        PrintStream logger = listener.getLogger();
        for (File f : reports) {
            try {
                SAXParser parser = factory.newSAXParser();
                final PerformanceReport r = new PerformanceReport();
                r.setReportFileName(f.getName());
                parser.parse(f, new DefaultHandler(){
                    private HttpSample currentSample;
                    private int status;

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (("testsuite".equalsIgnoreCase(qName) || "testcase".equalsIgnoreCase(qName)) && this.status != 0) {
                            r.addSample(this.currentSample);
                            this.status = 0;
                        }
                    }

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("testcase".equalsIgnoreCase(qName)) {
                            if (this.status != 0) {
                                r.addSample(this.currentSample);
                            }
                            this.status = 1;
                            this.currentSample = new HttpSample();
                            this.currentSample.setDate(new Date(0L));
                            String time = attributes.getValue("time");
                            this.currentSample.setDuration(JUnitParser.this.parseDuration(time));
                            this.currentSample.setSuccessful(true);
                            this.currentSample.setUri(attributes.getValue("name"));
                            this.currentSample.setErrorObtained(false);
                        } else if ("failure".equalsIgnoreCase(qName) && this.status != 0) {
                            this.currentSample.setErrorObtained(false);
                            this.currentSample.setSuccessful(false);
                            r.addSample(this.currentSample);
                            this.status = 0;
                        } else if ("failure".equalsIgnoreCase(qName) && this.status != 0) {
                            this.currentSample.setErrorObtained(true);
                            r.addSample(this.currentSample);
                            this.status = 0;
                        }
                    }
                });
                result.add(r);
            }
            catch (ParserConfigurationException e) {
                throw new IOException2("Failed to create parser ", (Throwable)e);
            }
            catch (SAXException e) {
                logger.println("Performance: Failed to parse " + f + ": " + e.getMessage());
            }
        }
        return result;
    }

    long parseDuration(String time) {
        double duration = Double.parseDouble(time.replaceAll(",", ""));
        return (long)(duration * 1000.0);
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JUnit";
        }
    }
}

