/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.plugins.performance.AbstractReport;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.UriReport;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceReport
extends AbstractReport
implements Serializable,
Comparable<PerformanceReport> {
    private static final long serialVersionUID = -1422875677867003355L;
    private transient PerformanceBuildAction buildAction;
    private HttpSample httpSample;
    private String reportFileName = null;
    private final Map<String, UriReport> uriReportMap = new LinkedHashMap<String, UriReport>();
    private PerformanceReport lastBuildReport;

    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        String staplerUri = uri.replace("http:", "").replaceAll("/", "_");
        UriReport uriReport = this.uriReportMap.get(staplerUri);
        if (uriReport == null) {
            uriReport = new UriReport(this, staplerUri, uri);
            this.uriReportMap.put(staplerUri, uriReport);
        }
        uriReport.addHttpSample(pHttpSample);
    }

    @Override
    public int compareTo(PerformanceReport jmReport) {
        if (this == jmReport) {
            return 0;
        }
        return this.getReportFileName().compareTo(jmReport.getReportFileName());
    }

    @Override
    public int countErrors() {
        int nbError = 0;
        for (UriReport currentReport : this.uriReportMap.values()) {
            nbError += currentReport.countErrors();
        }
        return nbError;
    }

    @Override
    public double errorPercent() {
        if (this.ifSummarizerParserUsed(this.reportFileName)) {
            float nbError = 0.0f;
            for (UriReport currentReport : this.uriReportMap.values()) {
                nbError += Float.valueOf(currentReport.getSummarizerErrors()).floatValue();
            }
            return (double)nbError / (double)this.uriReportMap.size();
        }
        return this.size() == 0 ? 0.0 : (double)this.countErrors() / (double)this.size() * 100.0;
    }

    @Override
    public long getAverage() {
        long result = 0L;
        int size = this.size();
        if (size != 0) {
            long average = 0L;
            for (UriReport currentReport : this.uriReportMap.values()) {
                average += currentReport.getAverage() * (long)currentReport.size();
            }
            double test = average / (long)size;
            result = (int)test;
        }
        return result;
    }

    public double getAverageSizeInKb() {
        double result = 0.0;
        int size = this.size();
        if (size != 0) {
            long average = 0L;
            for (UriReport currentReport : this.uriReportMap.values()) {
                average = (long)((double)average + currentReport.getAverageSizeInKb() * (double)currentReport.size());
            }
            result = (double)average / (double)size;
        }
        return this.roundTwoDecimals(result);
    }

    @Override
    public long get90Line() {
        long result = 0L;
        int size = this.size();
        if (size != 0) {
            long average = 0L;
            ArrayList<HttpSample> allSamples = new ArrayList<HttpSample>();
            for (UriReport currentReport : this.uriReportMap.values()) {
                allSamples.addAll(currentReport.getHttpSampleList());
            }
            Collections.sort(allSamples);
            result = ((HttpSample)allSamples.get((int)((double)allSamples.size() * 0.9))).getDuration();
        }
        return result;
    }

    @Override
    public long getMedian() {
        long result = 0L;
        int size = this.size();
        if (size != 0) {
            long average = 0L;
            ArrayList<HttpSample> allSamples = new ArrayList<HttpSample>();
            for (UriReport currentReport : this.uriReportMap.values()) {
                allSamples.addAll(currentReport.getHttpSampleList());
            }
            Collections.sort(allSamples);
            result = ((HttpSample)allSamples.get((int)((double)allSamples.size() * 0.5))).getDuration();
        }
        return result;
    }

    @Override
    public String getHttpCode() {
        return "";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public UriReport getDynamic(String token) throws IOException {
        return this.getUriReportMap().get(token);
    }

    public HttpSample getHttpSample() {
        return this.httpSample;
    }

    @Override
    public long getMax() {
        long max = Long.MIN_VALUE;
        for (UriReport currentReport : this.uriReportMap.values()) {
            max = Math.max(currentReport.getMax(), max);
        }
        return max;
    }

    public double getTotalTrafficInKb() {
        double result = 0.0;
        int size = this.size();
        if (size != 0) {
            for (UriReport currentReport : this.uriReportMap.values()) {
                result += currentReport.getTotalTrafficInKb();
            }
        }
        return this.roundTwoDecimals(result);
    }

    @Override
    public long getMin() {
        long min = Long.MAX_VALUE;
        for (UriReport currentReport : this.uriReportMap.values()) {
            min = Math.min(currentReport.getMin(), min);
        }
        return min;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public List<UriReport> getUriListOrdered() {
        Collection<UriReport> uriCollection = this.getUriReportMap().values();
        ArrayList<UriReport> UriReportList = new ArrayList<UriReport>(uriCollection);
        return UriReportList;
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setHttpSample(HttpSample httpSample) {
        this.httpSample = httpSample;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public int size() {
        int size = 0;
        for (UriReport currentReport : this.uriReportMap.values()) {
            size += currentReport.size();
        }
        return size;
    }

    public void setLastBuildReport(PerformanceReport lastBuildReport) {
        Map<String, UriReport> lastBuildUriReportMap = lastBuildReport.getUriReportMap();
        for (Map.Entry<String, UriReport> item : this.uriReportMap.entrySet()) {
            UriReport lastBuildUri = lastBuildUriReportMap.get(item.getKey());
            if (lastBuildUri == null) continue;
            item.getValue().addLastBuildUriReport(lastBuildUri);
        }
        this.lastBuildReport = lastBuildReport;
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildReport.getMedian();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildReport == null) {
            return 0.0;
        }
        return this.errorPercent() - this.lastBuildReport.errorPercent();
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        return "";
    }

    @Override
    public int getSizeDiff() {
        if (this.lastBuildReport == null) {
            return 0;
        }
        return this.size() - this.lastBuildReport.size();
    }

    public boolean ifSummarizerParserUsed(String filename) {
        boolean b = false;
        List<PerformanceReportParser> list = ((PerformancePublisher)this.buildAction.getBuild().getProject().getPublishersList().get(PerformancePublisher.class)).getParsers();
        for (int i = 0; i < list.size(); ++i) {
            String[] parts;
            if (!list.get(i).getDescriptor().getDisplayName().equals("JmeterSummarizer")) continue;
            String fileExt = list.get((int)i).glob;
            for (String path : parts = fileExt.split("\\s*[;:,]+\\s*")) {
                if (!filename.endsWith(path.substring(5))) continue;
                b = true;
                return b;
            }
        }
        return b;
    }

    private double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }
}

