/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.pegdown_formatter;

import hudson.Extension;
import hudson.Util;
import hudson.markup.MarkupFormatter;
import hudson.markup.MarkupFormatterDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jenkins_ci.plugins.pegdown_formatter.ExtensionUtils;
import org.jenkins_ci.plugins.pegdown_formatter.IsolatingClassLoader;
import org.jenkins_ci.plugins.pegdown_formatter.Messages;
import org.jenkins_ci.plugins.pegdown_formatter.PegDownExtension;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PegDownFormatter
extends MarkupFormatter {
    public static final String PEG_DOWN_BUNDLE = "/pegdown/plugin-pegdown-if.zip";
    private static final String FORMATTER_CLASS_NAME = "org.jenkins_ci.plugins.pegdown_formatter.impl.Formatter";
    private static final String FORMATTER_METHOD_NAME = "markdownToHtml";
    private static Method formatter;
    private final int flags;
    private final List<PegDownExtension> extensions;
    private final List<PegDownExtension> advancedExtensions;

    @DataBoundConstructor
    public PegDownFormatter(List<PegDownExtension> extensions, List<PegDownExtension> advancedExtensions) throws IOException {
        this.initFormatter();
        this.extensions = extensions;
        this.advancedExtensions = advancedExtensions;
        this.flags = ExtensionUtils.toFlags(extensions, advancedExtensions);
    }

    public String getCodeMirrorMode() {
        return this.extensions.get(0).isSelected() ? null : "htmlmixed";
    }

    public String getCodeMirrorConfig() {
        return "mode:'text/html'";
    }

    public List<PegDownExtension> getExtensions() {
        return this.extensions;
    }

    public List<PegDownExtension> getAdvancedExtensions() {
        return this.advancedExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initFormatter() {
        try {
            Class<PegDownFormatter> clazz = PegDownFormatter.class;
            synchronized (PegDownFormatter.class) {
                if (formatter == null) {
                    InputStream pegDownBundle = IsolatingClassLoader.class.getResourceAsStream(PEG_DOWN_BUNDLE);
                    IsolatingClassLoader pegDownClassLoader = new IsolatingClassLoader(pegDownBundle);
                    Class<?> formatterClass = pegDownClassLoader.loadClass(FORMATTER_CLASS_NAME);
                    formatter = formatterClass.getMethod(FORMATTER_METHOD_NAME, String.class, Integer.TYPE);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        {
            return;
        }
    }

    public void translate(String pegDown, Writer writer) throws IOException {
        if (Util.fixEmptyAndTrim((String)pegDown) == null) {
            return;
        }
        String html = null;
        try {
            html = (String)formatter.invoke(null, pegDown, this.flags);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
        writer.write(html);
    }

    public Object readResolve() {
        this.initFormatter();
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class PegDownFormatterDescriptor
    extends MarkupFormatterDescriptor {
        public String getDisplayName() {
            return Messages.pegDownFormatter();
        }

        public String getHelpUrl() {
            return super.getHelpFile("syntax");
        }

        public List<PegDownExtension> getDefaultExtensions() {
            return ExtensionUtils.DEFAULTS;
        }

        public List<PegDownExtension> getDefaultAdvancedExtensions() {
            return ExtensionUtils.ADVANCED_DEFAULTS;
        }
    }
}

