/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.Messages;
import hudson.plugins.parameterizedtrigger.PredefinedBuildParameters;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CounterBuildParameterFactory
extends AbstractBuildParameterFactory {
    private final String from;
    private final String to;
    private final String step;
    private final String paramExpr;
    private final SteppingValidationEnum validationFail;
    private static final VariableResolver<String> EMPTY_STRING_VARIABLE_RESOLVER = new VariableResolver<String>(){

        public String resolve(String name) {
            return "";
        }
    };

    public CounterBuildParameterFactory(long from, long to, long step, String paramExpr) {
        this(Long.toString(from), Long.toString(to), Long.toString(step), paramExpr);
    }

    public CounterBuildParameterFactory(long from, long to, long step, String paramExpr, SteppingValidationEnum validationFail) {
        this(Long.toString(from), Long.toString(to), Long.toString(step), paramExpr, validationFail);
    }

    public CounterBuildParameterFactory(String from, String to, String step, String paramExpr) {
        this(from, to, step, paramExpr, SteppingValidationEnum.FAIL);
    }

    @DataBoundConstructor
    public CounterBuildParameterFactory(String from, String to, String step, String paramExpr, SteppingValidationEnum validationFail) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.paramExpr = paramExpr;
        this.validationFail = validationFail;
    }

    @Override
    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        EnvVars envVars = build.getEnvironment(listener);
        long fromNum = Long.parseLong(envVars.expand(this.from));
        long toNum = Long.parseLong(envVars.expand(this.to));
        long stepNum = Long.parseLong(envVars.expand(this.step));
        ArrayList<AbstractBuildParameters> params = new ArrayList<AbstractBuildParameters>();
        int upDown = Long.signum(toNum - fromNum);
        if (upDown == 0) {
            params.add(this.getParameterForCount(fromNum));
        } else if (stepNum == 0L) {
            this.validationFail.failCheck(listener);
        } else if ((long)upDown * stepNum < 0L) {
            this.validationFail.failCheck(listener);
        } else {
            long i = fromNum;
            while ((long)upDown * i <= (long)upDown * toNum) {
                params.add(this.getParameterForCount(i));
                i += stepNum;
            }
        }
        return params;
    }

    private PredefinedBuildParameters getParameterForCount(Long i) {
        String stringWithCount = Util.replaceMacro((String)this.paramExpr, Collections.singletonMap("COUNT", i.toString()));
        return new PredefinedBuildParameters(stringWithCount);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getStep() {
        return this.step;
    }

    public String getParamExpr() {
        return this.paramExpr;
    }

    public SteppingValidationEnum getvalidationFail() {
        return this.validationFail;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.CounterBuildParameterFactory_CounterBuildParameterFactory();
        }

        public FormValidation doCheckFrom(@QueryParameter String value) {
            return this.validateNumberField(value);
        }

        public FormValidation doCheckTo(@QueryParameter String value) {
            return this.validateNumberField(value);
        }

        public FormValidation doCheckStep(@QueryParameter String value) {
            return this.validateNumberField(value);
        }

        private FormValidation validateNumberField(String value) {
            String valueWithoutVariables = Util.replaceMacro((String)value, EMPTY_STRING_VARIABLE_RESOLVER);
            if (StringUtils.isNotEmpty((String)valueWithoutVariables) && !this.isNumber(valueWithoutVariables)) {
                return FormValidation.warning((String)Messages.Hudson_NotANumber());
            }
            return FormValidation.validateRequired((String)value);
        }

        private boolean isNumber(String value) {
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
    }

    public static enum SteppingValidationEnum {
        FAIL("Fail the build step"),
        SKIP("Don't trigger these projects"){

            @Override
            public void failCheck(TaskListener listener) throws AbstractBuildParameters.DontTriggerException {
                listener.getLogger().println(Messages.CounterBuildParameterFactory_CountingWillNotTerminateSkipping());
                throw new AbstractBuildParameters.DontTriggerException();
            }
        }
        ,
        NOPARMS("Skip these parameters"){

            @Override
            public void failCheck(TaskListener listener) throws AbstractBuildParameters.DontTriggerException {
                listener.getLogger().println(Messages.CounterBuildParameterFactory_CountingWillNotTerminateIgnore());
            }
        };

        private final String description;

        public String getDescription() {
            return this.description;
        }

        private SteppingValidationEnum(String description) {
            this.description = description;
        }

        public void failCheck(TaskListener listener) throws AbstractBuildParameters.DontTriggerException {
            throw new RuntimeException(Messages.CounterBuildParameterFactory_CountingWillNotTerminate());
        }
    }
}

