/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.server.IOptionsServer;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class Workspace
implements Cloneable,
ExtensionPoint,
Describable<Workspace>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String charset;
    private boolean pinHost;
    private String rootPath;
    private String hostname;
    private Expand expand;
    private String syncID;
    private boolean cleanup;

    public Workspace(String charset, boolean pinHost, boolean cleanup) {
        this.charset = charset;
        this.pinHost = pinHost;
        this.cleanup = cleanup;
    }

    public abstract WorkspaceType getType();

    public abstract String getName();

    public abstract void setName(String var1);

    public String getCharset() {
        return this.charset;
    }

    public boolean isPinHost() {
        return this.pinHost;
    }

    public abstract IClient setClient(IOptionsServer var1, String var2) throws Exception;

    public WorkspaceDescriptor getDescriptor() {
        Jenkins j = Jenkins.getInstance();
        return (WorkspaceDescriptor)j.getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<Workspace, WorkspaceDescriptor> all() {
        Jenkins j = Jenkins.getInstance();
        return j.getDescriptorList(Workspace.class);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setExpand(Map<String, String> map) {
        this.expand = new Expand(map);
    }

    public Expand getExpand() {
        if (this.expand == null) {
            this.setExpand(new HashMap<String, String>());
        }
        return this.expand;
    }

    public void addEnv(String tag, String value) {
        this.expand.set(tag, value);
    }

    public String getFullName() {
        if (this.expand == null) {
            return this.getName();
        }
        String clientName = this.expand.format(this.getName(), false);
        clientName = this.expand.clean(clientName);
        this.expand.set("P4_CLIENT", clientName);
        return clientName;
    }

    public String getSyncID() {
        String id = null;
        if (this.expand == null) {
            return id;
        }
        id = this.syncID != null && !this.syncID.isEmpty() ? this.expand.formatID(this.syncID) : this.expand.formatID(this.getName());
        id = this.expand.clean(id);
        id = id.replaceAll(".clone\\d+$", "");
        return id;
    }

    @DataBoundSetter
    public void setSyncID(String syncID) {
        this.syncID = syncID;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Workspace deepClone() throws AbortException {
        try {
            return (Workspace)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AbortException(e.getMessage());
        }
    }
}

