/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.client.ClientOptions;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpecType;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ManualWorkspaceImpl
extends Workspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    public WorkspaceSpec spec;
    private static final Logger logger = Logger.getLogger(ManualWorkspaceImpl.class.getName());
    private static final String InitialViewExpandKey = "P4_INITIAL_VIEW";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public WorkspaceSpec getSpec() {
        return this.spec;
    }

    public void setSpec(WorkspaceSpec spec) {
        this.spec = spec;
    }

    @Override
    public WorkspaceType getType() {
        return WorkspaceType.MANUAL;
    }

    @DataBoundConstructor
    public ManualWorkspaceImpl(String charset, boolean pinHost, String name, WorkspaceSpec spec, boolean cleanup) {
        super(charset, pinHost, cleanup);
        this.name = name;
        this.spec = spec;
    }

    @Deprecated
    public ManualWorkspaceImpl(String charset, boolean pinHost, String name, WorkspaceSpec spec) {
        super(charset, pinHost, false);
        this.name = name;
        this.spec = spec;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ManualWorkspaceImpl ws = (ManualWorkspaceImpl)super.clone();
        ws.spec = (WorkspaceSpec)this.spec.clone();
        return ws;
    }

    private ClientView getClientView(WorkspaceSpec workspaceSpec) throws Exception {
        String clientName = this.getFullName();
        ClientView clientView = new ClientView();
        int order = 0;
        String specString = this.getExpand().format(workspaceSpec.getView(), true);
        for (String line : specString.split("\n\\s*")) {
            String origName = this.getExpand().format(this.getName(), false);
            line = line.replace(origName, clientName);
            try {
                ClientView.ClientViewMapping entry = new ClientView.ClientViewMapping(order, line);
                ++order;
                clientView.addEntry((IMapEntry)entry);
            }
            catch (Exception e) {
                String msg = "P4: invalid client view: " + line;
                logger.warning(msg);
                throw new AbortException(msg);
            }
        }
        return clientView;
    }

    private ArrayList<String> getChangeView(WorkspaceSpec workspaceSpec) {
        ArrayList<String> changeView = new ArrayList<String>();
        String view = workspaceSpec.getChangeView();
        if (view != null) {
            String specString = this.getExpand().format(view, true);
            for (String line : specString.split("\\n")) {
                changeView.add(line);
            }
        }
        return changeView;
    }

    private ClientOptions getClientOptions(WorkspaceSpec spec) {
        ClientOptions options = new ClientOptions();
        options.setAllWrite(spec.allwrite);
        options.setClobber(spec.clobber);
        options.setCompress(spec.compress);
        options.setLocked(spec.locked);
        options.setModtime(spec.modtime);
        options.setRmdir(spec.rmdir);
        return options;
    }

    @Override
    public IClient setClient(IOptionsServer connection, String user) throws Exception {
        String clientName = this.getFullName();
        IClient iclient = connection.getClient(clientName);
        if (iclient == null) {
            logger.info("P4: Creating manual client: " + clientName);
            iclient = new Client((IServer)connection);
            iclient.setName(clientName);
            iclient.setOwnerName(user);
            iclient.setRoot(this.getRootPath());
            if (connection.getServerVersionNumber() >= 20162) {
                WorkspaceSpecType type = this.parseClientType(this.getSpec().getType());
                if (connection.getServerVersionNumber() >= type.getMinVersion()) {
                    iclient.setType(type.getId());
                }
            }
        }
        iclient.setOwnerName(user);
        iclient.setOptions((IClientSummary.IClientOptions)this.getClientOptions(this.getSpec()));
        iclient.setLineEnd(this.parseLineEnd(this.getSpec().getLine()));
        String streamFullName = this.getSpec().getStreamName();
        if (streamFullName != null) {
            streamFullName = this.getExpand().format(streamFullName, true);
        }
        iclient.setStream(streamFullName);
        iclient.setClientView(this.getClientView(this.getSpec()));
        if (connection.getServerVersionNumber() >= 20172) {
            iclient.setChangeView(this.getChangeView(this.getSpec()));
        }
        if (connection.getServerVersionNumber() >= 20162) {
            WorkspaceSpecType type = this.parseClientType(this.getSpec().getType());
            if (connection.getServerVersionNumber() >= type.getMinVersion()) {
                switch (type) {
                    case GRAPH: 
                    case WRITABLE: {
                        iclient.setType(type.getId());
                        break;
                    }
                }
            }
        }
        iclient.setServerId(this.getSpec().getServerID());
        if (connection.getServerVersionNumber() >= 20172) {
            if (this.getSpec().isBackup()) {
                iclient.setBackup("enable");
            } else {
                iclient.setBackup("disable");
            }
        }
        return iclient;
    }

    private IClientSummary.ClientLineEnd parseLineEnd(String line) {
        for (IClientSummary.ClientLineEnd end : IClientSummary.ClientLineEnd.values()) {
            if (!end.name().equalsIgnoreCase(line)) continue;
            return end;
        }
        return IClientSummary.ClientLineEnd.LOCAL;
    }

    private WorkspaceSpecType parseClientType(String line) {
        for (WorkspaceSpecType type : WorkspaceSpecType.values()) {
            if (!type.name().equalsIgnoreCase(line)) continue;
            return type;
        }
        return WorkspaceSpecType.WRITABLE;
    }

    @JavaScriptMethod
    public JSONObject getSpecJSON(String client) {
        try {
            IOptionsServer p4 = ConnectionFactory.getConnection();
            IClient c = p4.getClient(client);
            StringBuffer sb = new StringBuffer();
            for (IClientViewMapping view : c.getClientView()) {
                sb.append(view.toString(" ", true));
                sb.append("\n");
            }
            JSONObject option = new JSONObject();
            option.put("allwrite", (Object)c.getOptions().isAllWrite());
            option.put("clobber", (Object)c.getOptions().isClobber());
            option.put("compress", (Object)c.getOptions().isCompress());
            option.put("locked", (Object)c.getOptions().isLocked());
            option.put("modtime", (Object)c.getOptions().isModtime());
            option.put("rmdir", (Object)c.getOptions().isRmdir());
            JSONObject spec = new JSONObject();
            spec.put("stream", (Object)(c.getStream() == null ? "" : c.getStream()));
            spec.put("line", (Object)c.getLineEnd().name());
            spec.put("view", (Object)sb.toString());
            spec.put("options", (Object)option);
            return spec;
        }
        catch (P4JavaException e) {
            JSONObject option = new JSONObject();
            option.put("allwrite", (Object)false);
            option.put("clobber", (Object)true);
            option.put("compress", (Object)false);
            option.put("locked", (Object)false);
            option.put("modtime", (Object)false);
            option.put("rmdir", (Object)false);
            JSONObject spec = new JSONObject();
            spec.put("stream", (Object)"");
            spec.put("line", (Object)"LOCAL");
            spec.put("view", (Object)"please define view...");
            spec.put("options", (Object)option);
            return spec;
        }
    }

    @Extension
    @Symbol(value={"manualSpec"})
    public static final class DescriptorImpl
    extends WorkspaceDescriptor {
        public String getDisplayName() {
            return "Manual (custom view)";
        }

        public AutoCompletionCandidates doAutoCompleteName(@QueryParameter String value) {
            return DescriptorImpl.autoCompleteName(value);
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return DescriptorImpl.checkClientName(value);
        }
    }
}

