/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import hudson.Util;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.review.ReviewProp;

public class Expand
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Expand.class.getName());
    private Map<String, String> formatTags = new HashMap<String, String>();

    public Expand(Map<String, String> map) {
        Jenkins jenkins = Jenkins.getInstance();
        DescribableList props = jenkins.getGlobalNodeProperties();
        if (props != null) {
            for (NodeProperty node : props) {
                if (!(node instanceof EnvironmentVariablesNodeProperty)) continue;
                EnvironmentVariablesNodeProperty env = (EnvironmentVariablesNodeProperty)node;
                this.formatTags.putAll((Map<String, String>)env.getEnvVars());
            }
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (ReviewProp.isProp(key)) {
                key = "p4." + key;
            }
            this.set(key, value);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String format(String format, boolean useKey) {
        if (this.formatTags != null) {
            format = Util.replaceMacro((String)format, this.formatTags);
        }
        if (useKey) {
            format = format.replace("${", "");
            format = format.replace("}", "");
        } else {
            format = format.replaceAll("\\$\\{.+?\\}", "");
        }
        return format;
    }

    public String formatID(String format) {
        if (this.formatTags != null) {
            for (Map.Entry<String, String> entry : this.formatTags.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if ("NODE_NAME".equals(key) || "EXECUTOR_NUMBER".equals(key) || "BUILD_NUMBER".equals(key) || value == null) continue;
                format = format.replace("${" + key + "}", value);
            }
        }
        format = format.replace("${", "");
        format = format.replace("}", "");
        return format;
    }

    public String clean(String id) {
        id = id.replaceAll(" ", "_");
        id = id.replaceAll(",", "-");
        id = id.replaceAll("=", "-");
        id = id.replaceAll("/", "-");
        return id;
    }

    public void set(String tag, String value) {
        this.formatTags.put(tag, value);
    }

    public String get(String tag) {
        if (this.formatTags == null) {
            return null;
        }
        return this.formatTags.get(tag);
    }
}

