/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workflow;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.tagging.TagNotifierStep;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class P4TaggingStep
extends Step {
    private final String rawLabelName;
    private final String rawLabelDesc;

    @DataBoundConstructor
    public P4TaggingStep(String rawLabelName, String rawLabelDesc) {
        this.rawLabelName = rawLabelName;
        this.rawLabelDesc = rawLabelDesc;
    }

    public String getRawLabelName() {
        return this.rawLabelName;
    }

    public String getRawLabelDesc() {
        return this.rawLabelDesc;
    }

    public StepExecution start(StepContext context) {
        return new P4TaggingStepExecution(context, this);
    }

    public static class P4TaggingStepExecution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient P4TaggingStep step;

        protected P4TaggingStepExecution(@Nonnull StepContext context, P4TaggingStep step) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            TagNotifierStep notifier = new TagNotifierStep(this.step.getRawLabelName(), this.step.getRawLabelDesc(), false);
            notifier.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension(optional=true)
    @Symbol(value={"label"})
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, TaskListener.class, EnvVars.class);
        }

        public String getFunctionName() {
            return "p4tag";
        }

        public String getDisplayName() {
            return "P4 Tag";
        }
    }
}

