/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.unshelve;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.tasks.UnshelveTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnshelveBuilder
extends Builder {
    private final String shelf;
    private final String resolve;
    private final boolean tidy;
    private final boolean ignoreEmpty;
    private static Logger logger = Logger.getLogger(UnshelveBuilder.class.getName());

    @DataBoundConstructor
    public UnshelveBuilder(String shelf, String resolve, boolean tidy, boolean ignoreEmpty) {
        this.shelf = shelf;
        this.resolve = resolve;
        this.tidy = tidy;
        this.ignoreEmpty = ignoreEmpty;
    }

    @Deprecated
    public UnshelveBuilder(String shelf, String resolve, boolean tidy) {
        this(shelf, resolve, tidy, false);
    }

    @Deprecated
    public UnshelveBuilder(String shelf, String resolve) {
        this(shelf, resolve, false, false);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getShelf() {
        return this.shelf;
    }

    public String getResolve() {
        return this.resolve;
    }

    public boolean isTidy() {
        return this.tidy;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        AbstractProject project = (AbstractProject)build.getParent();
        PerforceScm p4scm = PerforceScm.convertToPerforceScm(project.getScm());
        if (p4scm != null) {
            String credential = p4scm.getCredential();
            Workspace workspace = p4scm.getWorkspace();
            FilePath buildWorkspace = build.getWorkspace();
            try {
                if (buildWorkspace == null) {
                    return false;
                }
                return this.unshelve((Run<?, ?>)build, credential, workspace, buildWorkspace, (TaskListener)listener);
            }
            catch (IOException e) {
                logger.warning("Unable to Unshelve");
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                logger.warning("Unable to Unshelve");
                e.printStackTrace();
            }
        }
        return false;
    }

    protected boolean unshelve(Run<?, ?> run, String credential, Workspace workspace, FilePath buildWorkspace, TaskListener listener) throws IOException, InterruptedException {
        UnshelveTask task = new UnshelveTask(credential, run, listener, this.resolve, this.tidy);
        Workspace ws = task.setEnvironment(run, workspace, buildWorkspace);
        String id = ws.getExpand().format(this.shelf, false);
        if (this.ignoreEmpty && (id == null || id.isEmpty())) {
            logger.warning("Shelf list ID is empty or null, we will be skipping this task.");
            return true;
        }
        long change = Long.parseLong(id.trim());
        task.setShelf(change);
        task.setWorkspace(ws);
        return (Boolean)buildWorkspace.act((FilePath.FileCallable)task);
    }

    public static DescriptorImpl descriptor() {
        Jenkins j = Jenkins.getInstance();
        return (DescriptorImpl)j.getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"unshelve"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: Unshelve";
        }

        public static ListBoxModel doFillResolveItems() {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("Resolve: None", "none"), new ListBoxModel.Option("Resolve: Safe (-as)", "as"), new ListBoxModel.Option("Resolve: Merge (-am)", "am"), new ListBoxModel.Option("Resolve: Force Merge (-af)", "af"), new ListBoxModel.Option("Resolve: Yours (-ay) -- keep your edits", "ay"), new ListBoxModel.Option("Resolve: Theirs (-at) -- keep shelf content", "at")});
        }
    }
}

