/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.Label;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;

public class TaggingTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(TaggingTask.class.getName());
    private final String name;
    private final String description;
    private Object buildChange;

    public TaggingTask(String credential, Run<?, ?> run, TaskListener listener, String name, String description) {
        super(credential, run, listener);
        this.name = name;
        this.description = description;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Boolean)this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        try {
            if (!this.checkConnection(p4)) {
                return false;
            }
            p4.log("P4 Task: tagging build.");
            p4.log("... label: " + this.name);
            p4.log("... type: (automatic) @" + this.buildChange);
            Label label = new Label();
            label.setDescription(this.description);
            label.setName(this.name);
            label.setRevisionSpec("@" + this.buildChange);
            ViewMap viewMapping = new ViewMap();
            ClientView view = p4.getClientView();
            for (IClientViewMapping entry : view) {
                String left = entry.getLeft();
                Label.LabelMapping lblMap = new Label.LabelMapping();
                lblMap.setLeft("\"" + left + "\"");
                viewMapping.addEntry((IMapEntry)lblMap);
            }
            label.setViewMapping(viewMapping);
            p4.setLabel(label);
        }
        catch (Exception e) {
            p4.log("(p4):stop:exception\n");
            String msg = "Unable to label workspace: " + e;
            logger.warning(msg);
            throw e;
        }
        return true;
    }

    public void setBuildChange(Object buildChange) {
        this.buildChange = buildChange;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }
}

