/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.build.ExecutorHelper;
import org.jenkinsci.plugins.p4.build.NodeHelper;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.credentials.P4InvalidCredentialException;
import org.jenkinsci.plugins.p4.tasks.HostnameTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;

public abstract class AbstractTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AbstractTask.class.getName());
    private final P4BaseCredentials credential;
    private final TaskListener listener;
    private Workspace workspace;

    @Deprecated
    public AbstractTask(String credential, TaskListener listener) {
        this.credential = ConnectionHelper.findCredential(credential);
        this.listener = listener;
    }

    public AbstractTask(P4BaseCredentials credential, TaskListener listener) {
        this.credential = credential;
        this.listener = listener;
    }

    public AbstractTask(String credential, Item project, TaskListener listener) {
        this.credential = ConnectionHelper.findCredential(credential, project);
        this.listener = listener;
    }

    public AbstractTask(String credential, Run run, TaskListener listener) {
        this.credential = ConnectionHelper.findCredential(credential, run);
        this.listener = listener;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public abstract Object task(ClientHelper var1) throws Exception;

    public P4BaseCredentials getCredential() throws P4InvalidCredentialException {
        if (this.credential == null) {
            throw new P4InvalidCredentialException();
        }
        return this.credential;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public Workspace setEnvironment(Run<?, ?> run, Workspace wsType, FilePath buildWorkspace) throws IOException, InterruptedException {
        Workspace ws = wsType.deepClone();
        EnvVars envVars = run.getEnvironment(this.listener);
        String nodeName = NodeHelper.getNodeName(buildWorkspace);
        envVars.put("NODE_NAME", envVars.get("NODE_NAME", nodeName));
        String executor = ExecutorHelper.getExecutorID(buildWorkspace, this.listener);
        envVars.put("EXECUTOR_NUMBER", envVars.get("EXECUTOR_NUMBER", executor));
        ws.setExpand((Map<String, String>)envVars);
        String root = buildWorkspace.getRemote();
        if (root.contains("@")) {
            root = root.replace("@", "%40");
        }
        ws.setRootPath(root);
        if (ws.isPinHost()) {
            String hostname = AbstractTask.getHostName(buildWorkspace);
            ws.setHostName(hostname);
        } else {
            ws.setHostName("");
        }
        return ws;
    }

    private static String getHostName(FilePath buildWorkspace) {
        try {
            HostnameTask task = new HostnameTask();
            String hostname = (String)buildWorkspace.act((FilePath.FileCallable)task);
            return hostname;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getClientName() {
        return this.workspace.getFullName();
    }

    public String getSyncID() {
        return this.workspace.getSyncID();
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    protected boolean checkConnection(ClientHelper p4) {
        String host;
        p4.log("\nP4 Task: establishing connection.");
        if (!p4.isConnected()) {
            p4.log("P4: Server connection error: " + p4.getPort());
            return false;
        }
        p4.log("... server: " + p4.getPort());
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        p4.log("... node: " + host);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object tryTask() throws AbortException {
        try (ClientHelper p4 = new ClientHelper(this.getCredential(), this.listener, this.workspace);){
            if (p4.hasAborted()) {
                String msg = "P4: Previous Task Aborted!";
                logger.warning(msg);
                p4.log(msg);
                throw new AbortException(msg);
            }
            if (!this.checkConnection(p4)) {
                String msg = "P4: Unable to connect.";
                logger.warning(msg);
                p4.log(msg);
                throw new AbortException(msg);
            }
            Object msg = this.retryTask(p4);
            return msg;
        }
        catch (Exception e) {
            String msg = "P4: Task Exception: " + e.getMessage();
            logger.severe(msg);
            AbortException ae = new AbortException(msg);
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    private Object retryTask(ClientHelper p4) throws Exception {
        int t = 0;
        Exception last = null;
        while (t <= p4.getRetry()) {
            String msg;
            ++t;
            try {
                Object result = this.monitorTask(p4);
                if (p4.hasAborted()) {
                    msg = "P4: Task Aborted!";
                    logger.warning(msg);
                    p4.log(msg);
                    throw new AbortException(msg);
                }
                return result;
            }
            catch (Exception e) {
                last = e;
                msg = "P4 Task: attempt: " + t;
                logger.severe(msg);
                p4.log(msg);
                try {
                    TimeUnit.SECONDS.sleep(t ^ 2);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new Exception(last);
    }

    private Object monitorTask(ClientHelper p4) throws Exception {
        int tick = p4.getTick();
        if (tick == 0) {
            return this.task(p4);
        }
        Thread thread = new Thread(() -> {
            try {
                while (true) {
                    p4.log("...tick...");
                    Thread.sleep(tick);
                }
            }
            catch (InterruptedException e) {
                p4.log("...finished.");
                return;
            }
        });
        thread.start();
        Object result = this.task(p4);
        thread.interrupt();
        return result;
    }
}

