/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tagging;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.p4.tagging.TagAction;
import org.jenkinsci.plugins.p4.tagging.TagNotifier;
import org.jenkinsci.plugins.p4.workspace.Expand;

public class TagNotifierStep
extends TagNotifier
implements SimpleBuildStep {
    private static final Logger logger = Logger.getLogger(TagNotifierStep.class.getName());

    public TagNotifierStep(String rawLabelName, String rawLabelDesc, boolean onlyOnSuccess) {
        super(rawLabelName, rawLabelDesc, onlyOnSuccess);
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.onlyOnSuccess && run.getResult() != Result.SUCCESS) {
            return;
        }
        try {
            EnvVars env = run.getEnvironment(listener);
            Expand expand = new Expand((Map<String, String>)env);
            String name = expand.format(this.rawLabelName, false);
            String description = expand.format(this.rawLabelDesc, false);
            TagAction tagAction = this.getTagAction(env, run);
            tagAction.labelBuild(listener, name, description, workspace);
        }
        catch (Exception e) {
            String err = "P4: Could not label: " + e;
            logger.severe(err);
            throw new AbortException(err);
        }
    }

    private TagAction getTagAction(EnvVars env, Run<?, ?> run) {
        TagAction tagAction = TagAction.getLastAction(run);
        if (tagAction == null) {
            String jobName = (String)env.get((Object)"PROMOTED_JOB_NAME");
            if (jobName == null || jobName.isEmpty()) {
                logger.warning("No tag information; not a promotion job.");
                return tagAction;
            }
            String buildNumber = (String)env.get((Object)"PROMOTED_NUMBER");
            if (buildNumber == null || buildNumber.isEmpty()) {
                logger.warning("No tag information; not a promotion job.");
                return tagAction;
            }
            Jenkins j = Jenkins.getInstance();
            Job job = (Job)j.getItemByFullName(jobName, Job.class);
            if (job == null) {
                logger.warning("No job information; is it a valid Perforce job?");
                return tagAction;
            }
            int buildNum = Integer.parseInt(buildNumber);
            run = job.getBuildByNumber(buildNum);
            if (run == null) {
                logger.warning("No build number; is it a valid Perforce job?");
                return tagAction;
            }
            tagAction = (TagAction)run.getAction(TagAction.class);
            if (tagAction == null) {
                logger.warning("No tag information; is it a valid Perforce job?");
                return tagAction;
            }
        }
        return tagAction;
    }
}

