/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tagging;

import com.perforce.p4java.impl.generic.core.Label;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.AbstractScmTagAction;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.review.P4Review;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.tasks.CheckoutStatus;
import org.jenkinsci.plugins.p4.tasks.TaggingTask;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class TagAction
extends AbstractScmTagAction {
    private static Logger logger = Logger.getLogger(TagAction.class.getName());
    private String tag;
    private List<String> tags = new ArrayList<String>();
    private List<P4Ref> refChanges;
    private P4Revision buildChange;
    private P4Review review;
    private File changelog;
    private String jenkinsPath;
    private final String credential;
    private final String p4port;
    private final String p4user;
    private Workspace workspace;
    private String client;
    private String syncID;
    private transient String p4ticket;

    public TagAction(Run<?, ?> run, String credential) throws IOException, InterruptedException {
        super(run);
        P4BaseCredentials auth = ConnectionHelper.findCredential(credential, run);
        this.credential = credential;
        this.p4port = auth.getFullP4port();
        this.p4user = auth.getUsername();
    }

    public String getIconFileName() {
        if (!this.getACL().hasPermission(PerforceScm.TAG)) {
            return null;
        }
        return "/plugin/p4/icons/label.gif";
    }

    public String getDisplayName() {
        if (this.isTagged()) {
            return "Perforce Label";
        }
        return "Label This Build";
    }

    public boolean isTagged() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @POST
    public void doSubmit(StaplerRequest req, StaplerResponse rsp) throws Exception, ServletException {
        this.getACL().checkPermission(PerforceScm.TAG);
        String description = req.getParameter("desc");
        String name = req.getParameter("name");
        LogTaskListener listener = new LogTaskListener(logger, Level.INFO);
        this.labelBuild((TaskListener)listener, name, description, null);
        rsp.sendRedirect(".");
    }

    public void labelBuild(TaskListener listener, String name, String description, FilePath nodeWorkspace) throws Exception {
        EnvVars env = this.getRun().getEnvironment(listener);
        Expand expand = new Expand((Map<String, String>)env);
        name = expand.format(name, false);
        description = expand.format(description, false);
        TaggingTask task = new TaggingTask(this.credential, this.getRun(), listener, name, description);
        task.setWorkspace(this.workspace);
        task.setBuildChange(this.getRefChange());
        FilePath buildWorkspace = nodeWorkspace;
        if (nodeWorkspace == null) {
            buildWorkspace = this.build.getWorkspace();
        }
        if (buildWorkspace == null) {
            logger.warning("FilePath is null!");
            return;
        }
        Boolean ok = (Boolean)buildWorkspace.act((FilePath.FileCallable)task);
        if (ok.booleanValue() && !this.tags.contains(name)) {
            this.tags.add(name);
            this.getRun().save();
        }
    }

    public void setRefChanges(List<P4Ref> refChanges) {
        this.refChanges = refChanges;
    }

    public List<P4Ref> getRefChanges() {
        if (this.refChanges == null || this.refChanges.isEmpty()) {
            this.refChanges = new ArrayList<P4Ref>();
            if (this.buildChange != null) {
                if (this.buildChange.isLabel()) {
                    P4LabelRef label = new P4LabelRef(this.buildChange.toString());
                    this.refChanges.add(label);
                } else {
                    P4ChangeRef change = new P4ChangeRef(this.buildChange.getChange());
                    this.refChanges.add(change);
                }
            }
        }
        return this.refChanges;
    }

    public P4Ref getRefChange() {
        for (P4Ref change : this.refChanges) {
            if (change instanceof P4ChangeRef) {
                return change;
            }
            if (!(change instanceof P4LabelRef)) continue;
            return change;
        }
        return null;
    }

    @Deprecated
    public void setBuildChange(P4Revision buildChange) {
        this.buildChange = buildChange;
    }

    @Deprecated
    public P4Revision getBuildChange() {
        return this.buildChange;
    }

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.client = workspace.getFullName();
        this.syncID = workspace.getSyncID();
        Expand expand = workspace.getExpand();
        String id = expand.get(ReviewProp.SWARM_REVIEW.toString());
        if (id != null && !id.isEmpty()) {
            String type = expand.get(ReviewProp.SWARM_STATUS.toString());
            this.review = new P4Review(id, CheckoutStatus.parse(type));
        }
    }

    public String getPort() {
        return this.p4port;
    }

    public String getClient() {
        return this.client;
    }

    public String getSyncID() {
        return this.syncID;
    }

    public String getUser() {
        return this.p4user;
    }

    public String getTicket() {
        if (this.p4ticket != null) {
            return this.p4ticket;
        }
        logger.finer("TagAction:getTicket()");
        P4BaseCredentials auth = ConnectionHelper.findCredential(this.credential, this.getRun());
        try (ConnectionHelper p4 = new ConnectionHelper(auth, null);){
            this.p4ticket = p4.getTicket();
        }
        catch (Exception e) {
            logger.severe("P4: Unable to get Ticket(): " + e.getMessage());
        }
        return this.p4ticket;
    }

    public String getTag() {
        return this.tag;
    }

    public List<String> getTags() {
        return this.tags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Label getLabel(String tag) {
        P4BaseCredentials baseCredential = ClientHelper.findCredential(this.credential, this.getRun());
        try (ClientHelper p4 = new ClientHelper(baseCredential, null, this.workspace);){
            Label label2;
            Label label = label2 = p4.getLabel(tag);
            return label;
        }
        catch (Exception e) {
            logger.warning("Unable to get label from tag: " + tag);
            return null;
        }
    }

    public static List<P4Ref> getLastChange(Run<?, ?> run, TaskListener listener, String syncID) {
        List<P4Ref> changes = new ArrayList<P4Ref>();
        List<TagAction> actions = TagAction.lastActions(run);
        if (actions == null || syncID == null || syncID.isEmpty()) {
            listener.getLogger().println("No previous build found...");
            return changes;
        }
        logger.fine("   using syncID: " + syncID);
        ArrayList<String> syncList = new ArrayList<String>();
        for (TagAction action : actions) {
            if (syncList.contains(action.getSyncID())) {
                listener.getLogger().println("WARNING: duplicate syncID found: " + action.getSyncID());
                logger.severe("WARNING: duplicate syncID found: " + action.getSyncID());
            }
            syncList.add(action.getSyncID());
            logger.fine("   stored syncID: " + action.getSyncID());
        }
        for (TagAction action : actions) {
            if (!syncID.equals(action.getSyncID())) continue;
            changes = action.getRefChanges();
            for (P4Ref change : changes) {
                listener.getLogger().println("Found last change " + change.toString() + " on syncID " + syncID);
            }
        }
        return changes;
    }

    public static TagAction getLastAction(Run<?, ?> run) {
        List<TagAction> actions = TagAction.lastActions(run);
        if (actions == null) {
            return null;
        }
        TagAction tagAction = (TagAction)run.getAction(TagAction.class);
        for (TagAction t : run.getActions(TagAction.class)) {
            tagAction = t != null ? t : tagAction;
        }
        return tagAction;
    }

    private static List<TagAction> lastActions(Run<?, ?> run) {
        if (run == null) {
            return null;
        }
        List actions = run.getActions(TagAction.class);
        if (actions.isEmpty()) {
            return null;
        }
        return actions;
    }

    public P4Review getReview() {
        return this.review;
    }

    public void setChangelog(File changelog) {
        this.changelog = changelog;
    }

    public File getChangelog() {
        return this.changelog;
    }

    public void setJenkinsPath(String jenkinsPath) {
        this.jenkinsPath = jenkinsPath;
    }

    public String getJenkinsPath() {
        return this.jenkinsPath;
    }
}

