/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.swarmAPI;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.RootAction;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import jenkins.branch.BranchSource;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.populate.AutoCleanImpl;
import org.jenkinsci.plugins.p4.scm.SwarmScmSource;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmHelper;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Symbol(value={"swarm_projects"})
@Extension
public class SwarmQueryAction
implements RootAction {
    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "swarm";
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        PrintWriter out;
        Object list;
        String credentialID;
        String path = req.getRestOfPath();
        if (path != null && path.startsWith("/project")) {
            credentialID = req.getParameter("credential");
            try (ConnectionHelper p4 = new ConnectionHelper(credentialID, null);){
                SwarmHelper swarm = new SwarmHelper(p4, "4");
                list = swarm.getProjects();
                Gson gson = new Gson();
                String json = gson.toJson(list);
                out = rsp.getWriter();
                out.write(json);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (path != null && path.startsWith("/create")) {
            credentialID = req.getParameter("credential");
            String project = req.getParameter("project");
            String name = req.getParameter("name");
            if (name == null || name.isEmpty()) {
                name = project;
            }
            try {
                ConnectionHelper p4 = new ConnectionHelper(credentialID, null);
                list = null;
                try {
                    SwarmHelper swarm = new SwarmHelper(p4, "4");
                    String format = "jenkins-${NODE_NAME}-${JOB_NAME}";
                    SwarmScmSource source = new SwarmScmSource(credentialID, null, format);
                    source.setProject(project);
                    source.setSwarm(swarm);
                    source.setPopulate(new AutoCleanImpl());
                    WorkflowMultiBranchProject multi = (WorkflowMultiBranchProject)Jenkins.getInstance().createProject(WorkflowMultiBranchProject.class, name);
                    multi.getSourcesList().add((Object)new BranchSource((SCMSource)source));
                    multi.scheduleBuild2(0, new Action[0]);
                    rsp.setStatus(201);
                    rsp.setContentType("application/json");
                    JsonObject json = new JsonObject();
                    json.addProperty("name", name);
                    PrintWriter out2 = rsp.getWriter();
                    out2.write(json.toString());
                }
                catch (Throwable swarm) {
                    list = swarm;
                    throw swarm;
                }
                finally {
                    if (p4 != null) {
                        if (list != null) {
                            try {
                                p4.close();
                            }
                            catch (Throwable swarm) {
                                ((Throwable)list).addSuppressed(swarm);
                            }
                        } else {
                            p4.close();
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                rsp.setStatus(400);
                rsp.setContentType("application/json");
                JsonObject json = new JsonObject();
                json.addProperty("message", "Failed to create pipeline");
                json.addProperty("code", (Number)400);
                JsonArray errors = new JsonArray();
                JsonObject error = new JsonObject();
                error.addProperty("message", name + " already exists");
                error.addProperty("code", "ALREADY_EXISTS");
                error.addProperty("field", "name");
                errors.add((JsonElement)error);
                json.add("errors", (JsonElement)errors);
                out = rsp.getWriter();
                out.write(json.toString());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

