/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.swarmAPI;

import com.google.gson.Gson;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.review.ApproveState;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmProjectAPI;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmProjectsAPI;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmReviewAPI;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmReviewsAPI;
import org.json.JSONArray;

public class SwarmHelper {
    private final ConnectionHelper p4;
    private final String version;
    private final String base;
    private final String user;
    private final String ticket;

    public SwarmHelper(ConnectionHelper p4, String version) throws Exception {
        this.p4 = p4;
        this.version = version;
        this.base = p4.getSwarm();
        this.user = p4.getUser();
        this.ticket = p4.getTicket();
        if (!this.checkVersion(version)) {
            throw new Exception("Swarm does not support API Version: " + version);
        }
    }

    public String getBaseUrl() {
        return this.base;
    }

    private String getApiUrl() {
        return this.base + "/api/v" + this.version;
    }

    private boolean checkVersion(String ver) throws Exception {
        String url = this.base + "/api/version";
        HttpResponse res = Unirest.get((String)url).basicAuth(this.user, this.ticket).asJson();
        if (res.getStatus() != 200) {
            throw new SwarmException(res);
        }
        JSONArray json = ((JsonNode)res.getBody()).getObject().getJSONArray("apiVersions");
        for (int i = 0; i < json.length(); ++i) {
            String v = String.valueOf(json.get(i));
            if (!ver.equals(v)) continue;
            return true;
        }
        return false;
    }

    public boolean approveReview(String id, ApproveState state, String description) throws Exception {
        if (id == null || id.isEmpty()) {
            this.p4.log("Review ID is empty or null!");
            return false;
        }
        if ("P4_REVIEW".equalsIgnoreCase(id)) {
            this.p4.log("Environment for Review ID not found!");
            return false;
        }
        switch (state) {
            case VOTE_UP: 
            case VOTE_DOWN: {
                return this.postVote(id, state, description);
            }
        }
        return this.patchReview(id, state, description);
    }

    private boolean patchReview(String id, ApproveState state, String description) throws Exception {
        HttpResponse res;
        String url = this.getApiUrl() + "/reviews/" + id + "/state";
        HashedMap parameters = new HashedMap();
        parameters.put("state", state.getId());
        if (state.isCommit()) {
            parameters.put("commit", "1");
        }
        if (description != null && !description.isEmpty()) {
            parameters.put("description", description);
        }
        if ((res = Unirest.patch((String)url).basicAuth(this.user, this.ticket).fields((Map)parameters).asJson()).getStatus() == 200) {
            this.p4.log("Swarm review id: " + id + " updated: " + state.getDescription());
            return true;
        }
        this.p4.log("Swarm Error - url: " + url + " code: " + res.getStatus());
        String error = ((JsonNode)res.getBody()).getObject().getString("error");
        this.p4.log("Swarm error message: " + error);
        throw new SwarmException(res);
    }

    private boolean postComment(String id, String description) throws Exception {
        if (StringUtils.isEmpty((String)description)) {
            return true;
        }
        String url = this.getApiUrl() + "/comments/";
        HashedMap parameters = new HashedMap();
        parameters.put("topic", "reviews/" + id);
        parameters.put("body", description);
        HttpResponse res = Unirest.post((String)url).basicAuth(this.user, this.ticket).fields((Map)parameters).asJson();
        if (res.getStatus() == 200) {
            this.p4.log("Swarm review id: " + id + " comment: " + description);
            return true;
        }
        this.p4.log("Swarm Error - url: " + url + " code: " + res.getStatus());
        String error = ((JsonNode)res.getBody()).getObject().getString("error");
        this.p4.log("Swarm error message: " + error);
        throw new SwarmException(res);
    }

    private boolean postVote(String id, ApproveState state, String description) throws Exception {
        String vote = state.getId();
        String url = this.getBaseUrl() + "/reviews/" + id + "/vote/" + vote;
        HttpResponse res = Unirest.post((String)url).basicAuth(this.user, this.ticket).asJson();
        if (res.getStatus() == 200) {
            this.p4.log("Swarm review id: " + id + " voted: " + vote);
            return this.postComment(id, description);
        }
        this.p4.log("Swarm Error - url: " + url + " code: " + res.getStatus());
        String error = ((JsonNode)res.getBody()).getObject().getString("error");
        this.p4.log("Swarm error message: " + error);
        throw new SwarmException(res);
    }

    public List<SwarmReviewsAPI.Reviews> getActiveReviews(String project) throws Exception {
        String url = this.getApiUrl() + "/reviews";
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("max", "10");
        query.put("fields", "id,state,changes,author");
        query.put("project", project);
        HttpResponse res = Unirest.get((String)url).basicAuth(this.user, this.ticket).queryString(query).queryString("state[]", (Object)"needsReview").queryString("state[]", (Object)"needsRevision").asString();
        if (res.getStatus() != 200) {
            throw new SwarmException(res);
        }
        Gson gson = new Gson();
        SwarmReviewsAPI api = (SwarmReviewsAPI)gson.fromJson((String)res.getBody(), SwarmReviewsAPI.class);
        return api.getReviews();
    }

    public SwarmReviewAPI getSwarmReview(String review) throws Exception {
        String url = this.getApiUrl() + "/reviews/" + review;
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("fields", "projects,changes,commits,author");
        HttpResponse res = Unirest.get((String)url).basicAuth(this.user, this.ticket).queryString(query).asString();
        if (res.getStatus() != 200) {
            throw new SwarmException(res);
        }
        Gson gson = new Gson();
        SwarmReviewAPI api = (SwarmReviewAPI)gson.fromJson((String)res.getBody(), SwarmReviewAPI.class);
        return api;
    }

    public List<SwarmProjectAPI.Branch> getBranchesInProject(String project) throws Exception {
        String url = this.getApiUrl() + "/projects/" + project;
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("fields", "branches");
        HttpResponse res = Unirest.get((String)url).basicAuth(this.user, this.ticket).queryString(query).asString();
        if (res.getStatus() != 200) {
            throw new SwarmException(res);
        }
        Gson gson = new Gson();
        SwarmProjectAPI api = (SwarmProjectAPI)gson.fromJson((String)res.getBody(), SwarmProjectAPI.class);
        List<SwarmProjectAPI.Branch> branches = api.getProject().getBranches();
        return branches;
    }

    public List<String> getProjects() throws Exception {
        String url = this.getApiUrl() + "/projects";
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("fields", "id,members,owners");
        HttpResponse res = Unirest.get((String)url).basicAuth(this.user, this.ticket).queryString(query).asString();
        if (res.getStatus() != 200) {
            throw new SwarmException(res);
        }
        Gson gson = new Gson();
        SwarmProjectsAPI api = (SwarmProjectsAPI)gson.fromJson((String)res.getBody(), SwarmProjectsAPI.class);
        List<String> projects = api.getIDsByUser(this.user);
        return projects;
    }

    private static class SwarmException
    extends Exception {
        static final long serialVersionUID = 1L;

        public SwarmException(HttpResponse<?> res) {
            super("Swarm error - code: " + res.getStatus() + "\n error: " + res.getStatusText());
        }
    }
}

