/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class P4Path
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;
    private String revision;
    private List<String> mappings = new ArrayList<String>();

    public P4Path(String path) {
        this.path = path;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setMappings(List<String> mappings) {
        this.mappings.addAll(mappings);
    }

    public String getPathBuilder(String file) {
        String filePath = this.path + "/" + file;
        if (this.getRevision() == null) {
            return filePath;
        }
        return filePath + "@" + this.getRevision();
    }

    public String getName() {
        String r;
        String p = this.getPath();
        if (p.startsWith("//")) {
            p = p.substring("//".length());
            p = p.replaceAll("/", ".");
        }
        if ((r = this.getRevision()) != null) {
            if (r.startsWith("refs/pull/")) {
                r = r.substring("refs/pull/".length());
            }
            r = r.replaceAll("/", ".");
        }
        return p + "." + r;
    }

    public String getPath() {
        return this.path;
    }

    public String getNode() {
        return this.path.substring(this.path.lastIndexOf("/") + 1);
    }

    public String getRevision() {
        if (this.revision != null && this.revision.startsWith("refs/heads/")) {
            return this.revision.substring("refs/heads/".length());
        }
        return this.revision;
    }

    public List<String> getMappings() {
        return this.mappings;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getPath());
        String rev = this.getRevision();
        rev = rev == null ? "latest" : rev;
        sb.append("@");
        sb.append(rev);
        return sb.toString();
    }
}

