/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.client.NavigateHelper;
import org.jenkinsci.plugins.p4.client.TempClientHelper;
import org.jenkinsci.plugins.p4.client.ViewMapHelper;
import org.jenkinsci.plugins.p4.populate.GraphHybridImpl;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;
import org.jenkinsci.plugins.p4.scm.P4SCMRevision;
import org.jenkinsci.plugins.p4.scm.P4SCMSourceDescriptor;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GlobalLibraryScmSource
extends AbstractP4ScmSource {
    private final String path;

    public String getPath() {
        return this.path;
    }

    @DataBoundConstructor
    public GlobalLibraryScmSource(String credential, String charset, String path) {
        super(credential);
        this.path = path;
        this.setCharset(charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SCMRevision retrieve(@NonNull String thingName, @NonNull TaskListener listener) throws IOException, InterruptedException {
        P4Path p4Path = new P4Path(this.path);
        Workspace workspace = this.getWorkspace(p4Path);
        try (TempClientHelper p4 = new TempClientHelper((Item)this.getOwner(), this.credential, listener, workspace);){
            P4SCMRevision revision;
            p4Path.setRevision(thingName);
            P4SCMHead head = new P4SCMHead(thingName, p4Path);
            P4SCMRevision p4SCMRevision = revision = this.getRevision(p4, head);
            return p4SCMRevision;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public P4Browser getBrowser() {
        return null;
    }

    @Override
    public List<P4SCMHead> getHeads(@NonNull TaskListener listener) throws Exception {
        return new ArrayList<P4SCMHead>();
    }

    @Override
    public List<P4SCMHead> getTags(@NonNull TaskListener listener) throws Exception {
        return new ArrayList<P4SCMHead>();
    }

    @Override
    public synchronized PerforceScm build(@NonNull SCMHead head, SCMRevision revision) {
        if (head instanceof P4SCMHead && revision instanceof P4SCMRevision) {
            P4SCMHead perforceHead = (P4SCMHead)head;
            P4SCMRevision perforceRevision = (P4SCMRevision)revision;
            P4Path path = perforceHead.getPath();
            Workspace workspace = this.getWorkspace(path);
            String pin = perforceRevision.getRef().toString();
            GraphHybridImpl populate = new GraphHybridImpl(true, pin, null);
            PerforceScm scm = new PerforceScm(this.getCredential(), workspace, null, populate, this.getBrowser());
            return scm;
        }
        throw new IllegalArgumentException("SCMHead and/or SCMRevision not a Perforce instance!");
    }

    @Override
    public Workspace getWorkspace(P4Path path) {
        if (path == null) {
            throw new IllegalArgumentException("missing path");
        }
        UUID uuid = UUID.randomUUID();
        this.setFormat("jenkins-lib-" + uuid);
        String depotView = path.getPath();
        if (!depotView.endsWith("/...")) {
            depotView = depotView + "/...";
        }
        String client = this.getFormat();
        String view = ViewMapHelper.getClientView(depotView, client, true);
        boolean allwrite = true;
        boolean clobber = true;
        boolean compress = false;
        boolean locked = false;
        boolean modtime = false;
        boolean rmdir = false;
        String streamName = null;
        String line = "LOCAL";
        String changeView = null;
        String type = null;
        String serverID = null;
        boolean backup = true;
        WorkspaceSpec spec = new WorkspaceSpec(allwrite, clobber, compress, locked, modtime, rmdir, streamName, line, view, changeView, type, serverID, backup);
        return new ManualWorkspaceImpl(this.getCharset(), false, client, spec, true);
    }

    @Extension
    @Symbol(value={"globalLib"})
    public static final class DescriptorImpl
    extends P4SCMSourceDescriptor {
        public String getDisplayName() {
            return "Helix Library";
        }

        public FormValidation doCheckPath(@QueryParameter String value) {
            if (value == null || value.isEmpty() || !value.endsWith("/...")) {
                return FormValidation.error((String)"Please provide a valid Depot path e.g. //depot/libs/...");
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompletePath(@QueryParameter String value) {
            NavigateHelper nav = new NavigateHelper(10);
            return nav.getCandidates(value);
        }

        public boolean isApplicable(Class<? extends SCMSourceOwner> owner) {
            return false;
        }
    }
}

