/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.branch.BranchProjectFactory;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.changes.P4RefBuilder;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.client.TempClientHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.filters.FilterPerChangeImpl;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.scm.P4ChangeRequestSCMHead;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMBuilder;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;
import org.jenkinsci.plugins.p4.scm.P4SCMProbe;
import org.jenkinsci.plugins.p4.scm.P4SCMRevision;
import org.jenkinsci.plugins.p4.scm.events.P4BranchScanner;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractP4ScmSource
extends SCMSource {
    private static Logger logger = Logger.getLogger(AbstractP4ScmSource.class.getName());
    protected final String credential;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private String includes;
    private String charset;
    private String format;
    private Populate populate;
    private List<Filter> filter;

    public AbstractP4ScmSource(String credential) {
        this.credential = credential;
    }

    @DataBoundSetter
    public void setFormat(String format) {
        this.format = format;
    }

    @DataBoundSetter
    public void setPopulate(Populate populate) {
        this.populate = populate;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    @DataBoundSetter
    public void setFilter(List<Filter> filter) {
        this.filter = filter;
    }

    public String getCredential() {
        return this.credential;
    }

    public List<SCMSourceTrait> getTraits() {
        if (this.traits == null) {
            this.traits = new ArrayList<SCMSourceTrait>();
        }
        return Collections.unmodifiableList(this.traits);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getFormat() {
        return this.format;
    }

    public Populate getPopulate() {
        return this.populate;
    }

    public List<Filter> getFilter() {
        return this.filter;
    }

    public abstract P4Browser getBrowser();

    public abstract List<P4SCMHead> getHeads(@NonNull TaskListener var1) throws Exception;

    public abstract List<P4SCMHead> getTags(@NonNull TaskListener var1) throws Exception;

    public abstract Workspace getWorkspace(P4Path var1);

    public String getScriptPathOrDefault() {
        WorkflowMultiBranchProject branchProject;
        BranchProjectFactory project;
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof WorkflowMultiBranchProject && (project = (branchProject = (WorkflowMultiBranchProject)owner).getProjectFactory()) instanceof WorkflowBranchProjectFactory) {
            WorkflowBranchProjectFactory branchProjectFactory = (WorkflowBranchProjectFactory)project;
            return branchProjectFactory.getScriptPath();
        }
        return "Jenkinsfile";
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (TempClientHelper p4 = new TempClientHelper((Item)this.getOwner(), this.credential, listener, null);){
            List<P4SCMHead> heads = this.getHeads(listener);
            List<P4SCMHead> tags = this.getTags(listener);
            heads.addAll(tags);
            for (P4SCMHead head : heads) {
                logger.fine("SCM: retrieve Head: " + (Object)((Object)head));
                this.retrieveHead(p4, head, criteria, observer, event);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void retrieveHead(TempClientHelper p4, P4SCMHead head, SCMSourceCriteria criteria, SCMHeadObserver observer, SCMHeadEvent<?> event) throws Exception {
        P4Path p4Path = head.getPath();
        Workspace workspace = this.getWorkspace(p4Path);
        p4.update(workspace);
        SCMRevision revision = this.getEventRevision(head, event);
        if (revision == null) {
            revision = this.getRevision(p4, head);
        }
        if (criteria == null) {
            observer.observe((SCMHead)head, revision);
        } else {
            P4SCMProbe probe = new P4SCMProbe(p4, head);
            if (criteria.isHead((SCMSourceCriteria.Probe)probe, p4.getListener())) {
                logger.fine("SCM: observer head: " + (Object)((Object)head) + " revision: " + revision);
                if (revision != null) {
                    observer.observe(revision.getHead(), revision);
                }
            }
        }
        this.checkInterrupt();
    }

    private SCMRevision getEventRevision(P4SCMHead head, SCMHeadEvent<?> event) {
        if (event == null) {
            return null;
        }
        JSONObject payload = (JSONObject)event.getPayload();
        P4SCMRevision rev = this.getRevision(payload);
        if (rev.getHead().equals((Object)head)) {
            logger.fine("SCM: retrieve (trigger) Revision: " + (Object)((Object)rev));
            return rev;
        }
        if (rev.getHead() instanceof ChangeRequestSCMHead && ((P4ChangeRequestSCMHead)rev.getHead()).getPath().getPath().equals(head.getPath().getPath())) {
            logger.fine("SCM: retrieve (trigger) Swarm Review: " + (Object)((Object)rev));
            return rev;
        }
        return null;
    }

    protected SCMProbe createProbe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) throws IOException {
        return this.newProbe(head, revision);
    }

    public PerforceScm build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        return ((P4SCMBuilder)new P4SCMBuilder(this, head, revision).withTraits(this.getTraits())).build();
    }

    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        return result;
    }

    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        return result;
    }

    protected List<Action> retrieveActions(@NonNull SCMRevision revision, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        return result;
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        if (category instanceof ChangeRequestSCMHeadCategory) {
            return true;
        }
        if (category instanceof TagSCMHeadCategory) {
            return true;
        }
        return true;
    }

    public List<String> getIncludePaths() {
        return this.toLines(this.includes);
    }

    protected List<String> toLines(String value) {
        if (value == null) {
            return new ArrayList<String>();
        }
        String[] array = value.split("[\\r\\n]+");
        return Arrays.asList(array);
    }

    public P4SCMRevision getRevision(TempClientHelper p4, P4SCMHead head) throws Exception {
        long change;
        boolean perChange = FilterPerChangeImpl.isActive(this.getFilter());
        P4Path path = head.getPath();
        P4SCMRevision last = this.getLastScan(head);
        if (last == null) {
            change = this.findLatestChange(p4, path);
            if (change == 0L) {
                change = p4.getClientHead();
            }
        } else if (!perChange) {
            change = this.findLatestChange(p4, path);
            if (change == 0L) {
                change = last.getRef().getChange();
            }
        } else {
            change = this.findIncrementalChange(p4, path, last.getRef());
        }
        return new P4SCMRevision(head, new P4ChangeRef(change));
    }

    private long findLatestChange(ClientHelper p4, P4Path path) throws Exception {
        long to = this.getToLimit(p4, path.getRevision());
        P4ChangeRef toRef = new P4ChangeRef(to);
        long rangeLimit = to - p4.getHeadLimit();
        P4ChangeRef fromRef = rangeLimit > 0L ? new P4ChangeRef(rangeLimit) : null;
        long change = p4.getClientHead(fromRef, toRef);
        List<String> maps = path.getMappings();
        if (maps != null && !maps.isEmpty()) {
            for (String map : maps) {
                if (map.startsWith("-")) continue;
                long c = p4.getHead(map, fromRef, toRef);
                change = c > change ? c : change;
            }
        }
        return change;
    }

    private long getToLimit(ConnectionHelper p4, String to) throws Exception {
        String counter = p4.getCounter("change");
        long change = Long.parseLong(counter);
        if (to == null) {
            return change;
        }
        try {
            return Long.parseLong(to);
        }
        catch (NumberFormatException e) {
            return change;
        }
    }

    private long findIncrementalChange(ConnectionHelper p4, P4Path path, P4Ref ref) throws Exception {
        String toStr = path.getRevision();
        P4ChangeRef toRef = StringUtils.isEmpty((String)toStr) ? null : new P4ChangeRef(Long.parseLong(toStr));
        long change = ref.getChange();
        P4ChangeRef fromRef = new P4ChangeRef(change + 1L);
        long c = p4.getLowestHead(path.getPath() + "/...", fromRef, toRef);
        change = c > change ? c : change;
        List<String> maps = path.getMappings();
        if (maps != null && !maps.isEmpty()) {
            for (String map : maps) {
                c = p4.getLowestHead(map, fromRef, toRef);
                change = c > change ? c : change;
            }
        }
        return change;
    }

    private P4SCMRevision getLastScan(P4SCMHead head) {
        SCMSourceOwner owner = this.getOwner();
        if (!(owner instanceof WorkflowMultiBranchProject)) {
            return null;
        }
        WorkflowMultiBranchProject branchProject = (WorkflowMultiBranchProject)owner;
        BranchProjectFactory project = branchProject.getProjectFactory();
        if (project instanceof WorkflowBranchProjectFactory) {
            WorkflowBranchProjectFactory branchProjectFactory = (WorkflowBranchProjectFactory)project;
            WorkflowJob job = (WorkflowJob)branchProject.getJob(head.getName());
            if (job == null) {
                return null;
            }
            SCMRevision r = branchProjectFactory.getRevision((Job)job);
            if (r instanceof P4SCMRevision) {
                return (P4SCMRevision)r;
            }
            return null;
        }
        return null;
    }

    public P4SCMRevision getRevision(JSONObject payload) {
        String change = this.getProperty(payload, ReviewProp.P4_CHANGE);
        if (change == null) {
            return null;
        }
        P4Ref ref = P4RefBuilder.get(change);
        P4BranchScanner scanner = this.getScanner(ref);
        if (scanner == null) {
            return null;
        }
        String base = scanner.getProjectRoot();
        String branch = scanner.getBranch();
        String path = base + "/" + branch;
        return P4SCMRevision.builder(path, branch, ref);
    }

    protected P4BranchScanner getScanner(P4Ref ref) {
        P4BaseCredentials baseCredentials = ConnectionHelper.findCredential(this.credential, (Item)this.getOwner());
        P4BranchScanner scanner = new P4BranchScanner(baseCredentials, ref, this.getScriptPathOrDefault());
        if (scanner.getProjectRoot() == null || !this.findInclude(scanner.getProjectRoot())) {
            return null;
        }
        return scanner;
    }

    protected boolean findInclude(String path) {
        path = path.endsWith("/*") ? path.substring(0, path.lastIndexOf("/*")) : path;
        path = path.endsWith("/...") ? path.substring(0, path.lastIndexOf("/...")) : path;
        List<String> includes = this.getIncludePaths();
        for (String i : includes) {
            if (!i.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    protected String getProperty(JSONObject payload, ReviewProp property) {
        if (!payload.has(property.getProp())) {
            return null;
        }
        String value = payload.getString(property.getProp());
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }
}

