/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.publish;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.publish.PublishNotifier;
import org.jenkinsci.plugins.p4.tasks.PublishTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublishNotifierStep
extends PublishNotifier
implements SimpleBuildStep {
    @DataBoundConstructor
    public PublishNotifierStep(String credential, Workspace workspace, Publish publish) {
        super(credential, workspace, publish);
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.getPublish().isOnlyOnSuccess() && run.getResult() != Result.SUCCESS) {
            return;
        }
        Workspace ws = this.getWorkspace().deepClone();
        PublishTask task = new PublishTask(this.getCredential(), run, listener, this.getPublish());
        ws = task.setEnvironment(run, ws, buildWorkspace);
        task.setWorkspace(ws);
        String desc = this.getPublish().getDescription();
        desc = ws.getExpand().format(desc, false);
        this.getPublish().setExpandedDesc(desc);
        buildWorkspace.act((FilePath.FileCallable)task);
    }
}

