/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.groovy;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.p4.build.ExecutorHelper;
import org.jenkinsci.plugins.p4.build.NodeHelper;
import org.jenkinsci.plugins.p4.credentials.P4InvalidCredentialException;
import org.jenkinsci.plugins.p4.groovy.GetP4Task;
import org.jenkinsci.plugins.p4.groovy.P4Groovy;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetP4
extends Builder
implements SimpleBuildStep {
    private final String credential;
    private final Workspace workspace;
    private P4Groovy p4Groovy;

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public P4Groovy getP4Groovy() {
        return this.p4Groovy;
    }

    @DataBoundConstructor
    public GetP4(String credential, Workspace workspace) {
        this.credential = credential;
        this.workspace = workspace;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, @NonNull FilePath buildWorkspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        GetP4Task task;
        EnvVars envVars = run.getEnvironment(listener);
        String nodeName = NodeHelper.getNodeName(buildWorkspace);
        envVars.put("NODE_NAME", envVars.get("NODE_NAME", nodeName));
        String executor = ExecutorHelper.getExecutorID(buildWorkspace, listener);
        envVars.put("EXECUTOR_NUMBER", envVars.get("EXECUTOR_NUMBER", executor));
        this.workspace.setExpand((Map<String, String>)envVars);
        this.workspace.setRootPath(buildWorkspace.getRemote());
        try {
            task = new GetP4Task(run, this.credential, this.workspace, buildWorkspace, listener);
        }
        catch (P4InvalidCredentialException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        this.p4Groovy = (P4Groovy)buildWorkspace.act((Callable)task);
    }
}

