/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.filters;

import hudson.Extension;
import java.io.Serializable;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.filters.FilterDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilterLatestChangeImpl
extends Filter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean latestChange;

    @DataBoundConstructor
    public FilterLatestChangeImpl(boolean latestChange) {
        this.latestChange = latestChange;
    }

    public boolean isLatestChange() {
        return this.latestChange;
    }

    public static boolean isActive(List<Filter> filter) {
        if (filter == null) {
            return false;
        }
        for (Filter f : filter) {
            if (!(f instanceof FilterLatestChangeImpl) || !((FilterLatestChangeImpl)f).isLatestChange()) continue;
            return true;
        }
        return false;
    }

    @Extension
    @Symbol(value={"latest"})
    public static final class DescriptorImpl
    extends FilterDescriptor {
        public String getDisplayName() {
            return "Polling latest Change";
        }
    }
}

