/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IStreamingCallback;
import hudson.model.TaskListener;
import java.util.Map;
import org.jenkinsci.plugins.p4.client.Validate;
import org.jenkinsci.plugins.p4.console.P4Logging;

public abstract class AbstractStreamingCallback
implements IStreamingCallback {
    private boolean done = false;
    private boolean fail = false;
    private P4JavaException exception = null;
    private final Server server;
    private final Validate validate;
    private final TaskListener listener;

    public AbstractStreamingCallback(IServer iserver, TaskListener listener) {
        this.server = (Server)iserver;
        this.listener = listener;
        this.validate = new Validate(listener);
    }

    public boolean startResults(int key) throws P4JavaException {
        return true;
    }

    public boolean endResults(int key) throws P4JavaException {
        this.done = true;
        return true;
    }

    public abstract boolean handleResult(Map<String, Object> var1, int var2) throws P4JavaException;

    public boolean isDone() {
        return this.done;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail() {
        this.fail = true;
    }

    public P4JavaException getException() {
        return this.exception;
    }

    public void setException(P4JavaException exception) {
        this.exception = exception;
    }

    public Server getServer() {
        return this.server;
    }

    public Validate getValidate() {
        return this.validate;
    }

    protected void log(Map<String, Object> map) {
        if (this.listener == null) {
            return;
        }
        if (map == null || map.isEmpty() || map.get("depotFile") == null) {
            return;
        }
        if (this.isQuiet()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        String action = map.get("action") == null ? "" : (String)map.get("action");
        String clientFile = map.get("clientFile") == null ? "" : (String)map.get("clientFile");
        String depotFile = map.get("depotFile") == null ? "" : (String)map.get("depotFile");
        String rev = map.get("rev") == null ? "" : (String)map.get("rev");
        msg.append(depotFile + "#" + rev);
        msg.append(" - ");
        msg.append(clientFile + " ");
        msg.append(action);
        this.listener.getLogger().println(msg.toString());
    }

    private boolean isQuiet() {
        ICommandCallback callback = this.server.registerCallback(null);
        this.server.registerCallback(callback);
        if (callback instanceof P4Logging) {
            P4Logging logging = (P4Logging)callback;
            return logging.isQuiet();
        }
        return false;
    }
}

