/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.file.IFileSpec;
import java.util.List;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;

public class P4LabelRef
implements P4Ref {
    private static final long serialVersionUID = 1L;
    private final String label;

    public P4LabelRef(String label) {
        this.label = label;
    }

    @Override
    public P4ChangeEntry getChangeEntry(ClientHelper p4) throws Exception {
        P4ChangeEntry cl = new P4ChangeEntry();
        cl.setLabel(p4, this.label);
        return cl;
    }

    @Override
    public boolean isLabel() {
        return true;
    }

    @Override
    public boolean isCommit() {
        return false;
    }

    @Override
    public long getChange() {
        return -1L;
    }

    @Override
    public List<IFileSpec> getFiles(ConnectionHelper p4, int limit) throws Exception {
        return p4.getLabelFiles(this.label, limit);
    }

    @Override
    public String toString() {
        return this.label;
    }

    public boolean equals(Object obj) {
        P4LabelRef ref;
        return obj instanceof P4LabelRef && (ref = (P4LabelRef)obj).toString().equals(this.toString());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.toString().hashCode();
        return hash;
    }

    public int compareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (obj instanceof P4LabelRef) {
            P4LabelRef ref = (P4LabelRef)obj;
            if (ref.toString().equals("now")) {
                return -1;
            }
            if (this.label.equals("now")) {
                return 1;
            }
            if (ref.isLabel()) {
                return 0;
            }
        }
        throw new ClassCastException();
    }
}

