/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.IFileSpec;
import java.util.List;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;

public class P4ChangeRef
implements P4Ref {
    private static final long serialVersionUID = 1L;
    private final long change;

    public P4ChangeRef(long change) {
        this.change = change;
    }

    @Override
    public P4ChangeEntry getChangeEntry(ClientHelper p4) throws Exception {
        P4ChangeEntry cl = new P4ChangeEntry();
        IChangelistSummary summary = p4.getChangeSummary(this.change);
        cl.setChange(p4, summary);
        return cl;
    }

    @Override
    public boolean isLabel() {
        return false;
    }

    @Override
    public boolean isCommit() {
        return false;
    }

    @Override
    public long getChange() {
        return this.change;
    }

    @Override
    public List<IFileSpec> getFiles(ConnectionHelper p4, int limit) throws Exception {
        return p4.getChangeFiles(this.change, limit);
    }

    @Override
    public String toString() {
        return Long.toString(this.change);
    }

    public boolean equals(Object obj) {
        P4ChangeRef ref;
        return obj instanceof P4ChangeRef && (ref = (P4ChangeRef)obj).toString().equals(this.toString());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.toString().hashCode();
        return hash;
    }

    public int compareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (obj instanceof P4ChangeRef) {
            P4ChangeRef ref = (P4ChangeRef)obj;
            return (int)(this.change - ref.getChange());
        }
        throw new ClassCastException();
    }
}

