/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Fix;
import hudson.model.Run;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jenkinsci.plugins.p4.browsers.SwarmBrowser;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4ChangeSet;
import org.jenkinsci.plugins.p4.changes.P4GraphRef;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P4ChangeParser
extends ChangeLogParser {
    private static Logger logger = Logger.getLogger(P4ChangeParser.class.getName());
    private final String credential;

    public P4ChangeParser(String credential) {
        this.credential = credential;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeLogSet<? extends ChangeLogSet.Entry> parse(Run run, RepositoryBrowser<?> browser, File file) throws IOException, SAXException {
        try (ConnectionHelper p4 = new ConnectionHelper(run, this.credential, null);){
            P4ChangeSet changeSet;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ChangeLogHandler handler = new ChangeLogHandler(run, browser, p4);
            parser.parse(file, (DefaultHandler)handler);
            P4ChangeSet p4ChangeSet = changeSet = handler.getChangeLogSet();
            return p4ChangeSet;
        }
        catch (Exception e) {
            logger.severe("Could not parse Perforce changelog: " + file.toString());
            return new P4ChangeSet(run, browser, new ArrayList<P4ChangeEntry>());
        }
    }

    public static class ChangeLogHandler
    extends DefaultHandler {
        private Stack<P4ChangeEntry> objects;
        private StringBuffer text;
        private List<P4ChangeEntry> changeEntries;
        private P4ChangeSet changeSet;
        private Run<?, ?> run;
        private RepositoryBrowser<?> browser;
        private ConnectionHelper p4;

        public ChangeLogHandler(Run<?, ?> run, RepositoryBrowser<?> browser, ConnectionHelper p4) throws P4JavaException {
            block4: {
                this.objects = new Stack();
                this.text = new StringBuffer();
                this.run = run;
                this.browser = browser;
                this.p4 = p4;
                if (browser == null) {
                    try {
                        String url = p4.getSwarm();
                        if (url != null) {
                            this.browser = new SwarmBrowser(url);
                        }
                    }
                    catch (RequestException re) {
                        if (re.getMessage() == null || re.getMessage().contains("Unknown command")) break block4;
                        throw re;
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.text.append(ch, start, length);
        }

        @Override
        public void startDocument() throws SAXException {
            this.changeEntries = new ArrayList<P4ChangeEntry>();
            this.changeSet = new P4ChangeSet(this.run, this.browser, this.changeEntries);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("changelog")) {
                this.text.setLength(0);
                return;
            }
            if (qName.equalsIgnoreCase("entry")) {
                this.objects.push(new P4ChangeEntry(this.changeSet));
                this.text.setLength(0);
                return;
            }
            if (this.objects.peek() instanceof P4ChangeEntry) {
                P4ChangeEntry entry = this.objects.peek();
                try {
                    if (qName.equalsIgnoreCase("file")) {
                        String safePath = attributes.getValue("depot");
                        String depotPath = URLDecoder.decode(safePath, "UTF-8");
                        String a = attributes.getValue("action");
                        FileAction action = FileAction.valueOf((String)a);
                        String strRev = attributes.getValue("endRevision");
                        P4AffectedFile file = new P4AffectedFile(depotPath, strRev, action);
                        entry.addAffectedFiles(file);
                        this.text.setLength(0);
                        return;
                    }
                    if (qName.equalsIgnoreCase("job")) {
                        Fix temp = new Fix();
                        String id = attributes.getValue("id");
                        temp.setJobId(id);
                        String status = attributes.getValue("status");
                        temp.setStatus(status);
                        entry.addJob((IFix)temp);
                        this.text.setLength(0);
                        return;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    entry = null;
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("changelog")) {
                return;
            }
            if (qName.equalsIgnoreCase("entry")) {
                P4ChangeEntry entry = this.objects.pop();
                this.changeEntries.add(entry);
                return;
            }
            if (this.objects.peek() instanceof P4ChangeEntry) {
                P4ChangeEntry entry = this.objects.peek();
                try {
                    if (this.text.toString().trim().length() != 0 && (qName.equalsIgnoreCase("changenumber") || qName.equalsIgnoreCase("label") || qName.equalsIgnoreCase("commit"))) {
                        if (qName.equalsIgnoreCase("changenumber")) {
                            int id = Integer.parseInt(this.text.toString());
                            IChangelistSummary summary = this.p4.getChangeSummary(id);
                            entry.setChange(this.p4, summary);
                        }
                        if (qName.equalsIgnoreCase("label")) {
                            String id = this.text.toString();
                            entry.setLabel(this.p4, id);
                        }
                        if (qName.equalsIgnoreCase("commit")) {
                            String id = this.text.toString();
                            entry.setGraphCommit(this.p4, id);
                        }
                    } else {
                        String elementText = this.text.toString().trim();
                        if (qName.equalsIgnoreCase("changeInfo")) {
                            if (elementText.contains("@")) {
                                entry.setId(new P4GraphRef(this.p4, elementText));
                                this.text.setLength(0);
                                return;
                            }
                            int id = Integer.parseInt(elementText);
                            entry.setId(new P4ChangeRef(id));
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("shelved")) {
                            entry.setShelved(elementText.equals("true"));
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("msg")) {
                            entry.setMsg(elementText);
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("clientId")) {
                            entry.setClientId(elementText);
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("changeUser")) {
                            entry.setAuthor(elementText);
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("changeTime")) {
                            entry.setDate(elementText);
                            this.text.setLength(0);
                            return;
                        }
                    }
                    this.text.setLength(0);
                    return;
                }
                catch (Exception e) {
                    entry = null;
                }
            }
        }

        public P4ChangeSet getChangeLogSet() {
            return this.changeSet;
        }
    }
}

