/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SwarmBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SwarmBrowser(String url) {
        super(url);
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.getSafeUrl() + "change/" + changeSet.getId());
    }

    public URL getLabelSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.getSafeUrl() + "label/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(P4AffectedFile file, P4Ref change) throws Exception {
        return null;
    }

    @Override
    public URL getFileLink(P4AffectedFile file) throws Exception {
        int r = this.parseRevision(file);
        String path = file.getPath();
        path = path.replace("//", "files/");
        String rev = "?v=" + r;
        return new URL(this.getSafeUrl() + path + rev);
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return new URL(this.getSafeUrl() + "jobs/" + job);
    }

    @Extension
    @Symbol(value={"swarm"})
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Swarm browser";
        }

        public FormValidation doCheck(@QueryParameter String value) throws IOException, ServletException {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
            }
            return FormValidation.ok();
        }

        public SwarmBrowser newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return req == null ? null : (SwarmBrowser)((Object)req.bindJSON(SwarmBrowser.class, jsonObject));
        }
    }
}

