/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.server.IOptionsServer;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.client.NavigateHelper;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SpecWorkspaceImpl
extends Workspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private final String specPath;
    private static Logger logger = Logger.getLogger(SpecWorkspaceImpl.class.getName());

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getSpecPath() {
        return this.specPath;
    }

    @Override
    public WorkspaceType getType() {
        return WorkspaceType.SPEC;
    }

    @DataBoundConstructor
    public SpecWorkspaceImpl(String charset, boolean pinHost, String name, String specPath) {
        super(charset, pinHost, false);
        this.name = name;
        this.specPath = specPath;
    }

    @Override
    public IClient setClient(IOptionsServer connection, String user) throws Exception {
        String clientName = this.getFullName();
        String specPathFull = this.getExpand().format(this.getSpecPath(), false);
        List file = FileSpecBuilder.makeFileSpecList((String[])new String[]{specPathFull});
        GetFileContentsOptions printOpts = new GetFileContentsOptions();
        printOpts.setNoHeaderLine(true);
        InputStream ins = connection.getFileContents(file, printOpts);
        String spec = IOUtils.toString((InputStream)ins, (String)"UTF-8");
        spec = this.getExpand().format(spec, false);
        if (!spec.contains(clientName)) {
            throw new Exception("Spec file does not match client.");
        }
        List resultMap = connection.execInputStringMapCmdList("client", new String[]{"-i"}, spec);
        String msg = ResultMapParser.parseCommandResultMapAsString((List)resultMap);
        logger.fine(msg);
        IClient iclient = connection.getClient(clientName);
        iclient.setName(clientName);
        iclient.setOwnerName(user);
        iclient.refresh();
        return iclient;
    }

    @Extension
    @Symbol(value={"specFileSpec"})
    public static final class DescriptorImpl
    extends WorkspaceDescriptor {
        public String getDisplayName() {
            return "Spec File (load workspace spec from file in Perforce)";
        }

        public AutoCompletionCandidates doAutoCompleteName(@QueryParameter String value) {
            return DescriptorImpl.autoCompleteName(value);
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return DescriptorImpl.checkClientName(value);
        }

        public AutoCompletionCandidates doAutoCompleteSpecPath(@QueryParameter String value) {
            NavigateHelper nav = new NavigateHelper(10);
            return nav.getCandidates(value);
        }

        public FormValidation doCheckSpecPath(@QueryParameter String value) {
            try {
                IOptionsServer p4 = ConnectionFactory.getConnection();
                List file = FileSpecBuilder.makeFileSpecList((String[])new String[]{value});
                GetFileContentsOptions printOpts = new GetFileContentsOptions();
                InputStream ins = p4.getFileContents(file, printOpts);
                if (ins != null) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)("Unknown file: " + value));
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

