/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.inject.Inject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.tagging.TagNotifierStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class P4TaggingStep
extends AbstractStepImpl {
    private final String rawLabelName;
    private final String rawLabelDesc;

    @DataBoundConstructor
    public P4TaggingStep(String rawLabelName, String rawLabelDesc) {
        this.rawLabelName = rawLabelName;
        this.rawLabelDesc = rawLabelDesc;
    }

    public String getRawLabelName() {
        return this.rawLabelName;
    }

    public String getRawLabelDesc() {
        return this.rawLabelDesc;
    }

    public static class P4TaggingStepExecution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient P4TaggingStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;

        protected Void run() throws Exception {
            TagNotifierStep notifier = new TagNotifierStep(this.step.getRawLabelName(), this.step.getRawLabelDesc(), false);
            notifier.perform(this.run, this.workspace, this.launcher, this.listener);
            return null;
        }
    }

    @Extension(optional=true)
    @Symbol(value={"label"})
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(P4TaggingStepExecution.class);
        }

        public String getFunctionName() {
            return "p4tag";
        }

        public String getDisplayName() {
            return "P4 Tag";
        }
    }
}

