/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workflow;

import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.populate.AutoCleanImpl;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.workflow.source.AbstractSource;
import org.jenkinsci.plugins.p4.workflow.source.DepotSource;
import org.jenkinsci.plugins.p4.workflow.source.StreamSource;
import org.jenkinsci.plugins.p4.workflow.source.TemplateSource;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class P4Step
extends SCMStep {
    private static final long serialVersionUID = 1L;
    private final String credential;
    private String stream = "";
    private String depotPath = "";
    private String template = "";
    private String charset = "";
    private String format = "jenkins-${NODE_NAME}-${JOB_NAME}-${EXECUTOR_NUMBER}";
    private Populate populate;
    private Workspace workspace;
    private AbstractSource source;

    @DataBoundConstructor
    public P4Step(String credential) {
        this.credential = credential;
    }

    public String getStream() {
        return this.stream;
    }

    @DataBoundSetter
    public void setStream(String stream) {
        this.stream = stream;
        if (stream != null && !stream.isEmpty()) {
            this.source = new StreamSource(stream);
        }
    }

    public String getDepotPath() {
        return this.depotPath;
    }

    @DataBoundSetter
    public void setDepotPath(String path) {
        this.depotPath = path;
        if (path != null && !path.isEmpty()) {
            this.source = new DepotSource(path);
        }
    }

    public String getTemplate() {
        return this.template;
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = template;
        if (template != null && !template.isEmpty()) {
            this.source = new TemplateSource(template);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    @DataBoundSetter
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getFormat() {
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(String format) {
        this.format = format;
    }

    public String getCredential() {
        return this.credential;
    }

    @DataBoundSetter
    public void setPopulate(Populate populate) {
        this.populate = populate;
    }

    public Populate getPopulate() {
        return this.populate;
    }

    public AbstractSource getSource() {
        return this.source;
    }

    @DataBoundSetter
    public void setSource(AbstractSource source) {
        this.source = source;
    }

    protected SCM createSCM() {
        P4Browser browser = PerforceScm.findBrowser(this.credential);
        if (this.workspace == null) {
            this.workspace = this.getSource().getWorkspace(this.charset, this.format);
        }
        if (this.populate == null) {
            this.populate = new AutoCleanImpl();
        }
        PerforceScm scm = new PerforceScm(this.credential, this.workspace, null, this.populate, browser);
        return scm;
    }

    static boolean notNull(String value) {
        return value != null && !value.isEmpty();
    }

    @Extension(optional=true)
    @Symbol(value={"p4sync"})
    public static final class DescriptorImpl
    extends SCMStep.SCMStepDescriptor {
        public static final String defaultFormat = "jenkins-${NODE_NAME}-${JOB_NAME}-${EXECUTOR_NUMBER}";

        public DescriptorImpl() {
            PerforceScm.class.hashCode();
        }

        public ListBoxModel doFillCredentialItems(@AncestorInPath Item project, @QueryParameter String credential) {
            return P4CredentialsImpl.doFillCredentialItems(project, credential);
        }

        public FormValidation doCheckCredential(@AncestorInPath Item project, @QueryParameter String value) {
            return P4CredentialsImpl.doCheckCredential(project, value);
        }

        public ListBoxModel doFillCharsetItems() {
            return WorkspaceDescriptor.doFillCharsetItems();
        }

        public String getFunctionName() {
            return "p4sync";
        }

        public String getDisplayName() {
            return "P4 Sync";
        }
    }
}

