/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.trigger;

import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class P4Trigger
extends Trigger<Job<?, ?>> {
    static final Logger LOGGER = Logger.getLogger(P4Trigger.class.getName());

    @DataBoundConstructor
    public P4Trigger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poke(Job<?, ?> job, String port) throws IOException {
        if (!this.matchServer(job, port)) {
            return;
        }
        LOGGER.info("P4: poking: " + job.getName());
        try (StreamTaskListener listener = new StreamTaskListener(this.getLogFile(job));){
            PrintStream log = listener.getLogger();
            SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
            if (item == null) {
                LOGGER.severe("Trigger item not found.");
                return;
            }
            PollingResult pollResult = item.poll((TaskListener)listener);
            if (pollResult != null && pollResult.hasChanges()) {
                log.println("P4: Changes found");
                this.build(job);
            } else {
                log.println("P4: No changes");
            }
        }
    }

    private void build(final Job<?, ?> job) throws IOException {
        SCMTrigger.SCMTriggerCause cause = new SCMTrigger.SCMTriggerCause(this.getLogFile(job));
        ParameterizedJobMixIn pJob = new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        };
        pJob.scheduleBuild((Cause)cause);
    }

    public File getLogFile(Job<?, ?> job) {
        if (job == null) {
            return null;
        }
        return new File(job.getRootDir(), "p4trigger.log");
    }

    private boolean matchServer(Job<?, ?> job, String port) {
        SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
        if (item != null) {
            for (SCM scmTrigger : item.getSCMs()) {
                String id;
                P4BaseCredentials credential;
                PerforceScm p4scm = PerforceScm.convertToPerforceScm(scmTrigger);
                if (p4scm == null || (credential = ConnectionHelper.findCredential(id = p4scm.getCredential())) == null || credential.getP4port() == null || !port.equals(credential.getP4port())) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new P4TriggerAction());
    }

    public final class P4TriggerAction
    implements Action {
        public Job<?, ?> getOwner() {
            return (Job)P4Trigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "P4 Trigger Log";
        }

        public String getUrlName() {
            return "P4TriggerLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)P4Trigger.this.getLogFile((Job)P4Trigger.this.job));
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(P4Trigger.this.getLogFile((Job)P4Trigger.this.job), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }

    @Extension
    @Symbol(value={"p4Trigger"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof Job;
        }

        public String getDisplayName() {
            return "Perforce triggered build.";
        }
    }
}

