/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class UnshelveTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UnshelveTask.class.getName());
    private final String resolve;
    private final boolean tidy;
    private long shelf;

    public UnshelveTask(String credential, Run<?, ?> run, TaskListener listener, String resolve, boolean tidy) {
        super(credential, run, listener);
        this.resolve = resolve;
        this.tidy = tidy;
    }

    public void setShelf(long shelf) {
        this.shelf = shelf;
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        try {
            if (!this.checkConnection(p4)) {
                return false;
            }
            p4.unshelveFiles(this.shelf);
            p4.resolveFiles(this.resolve);
            if (this.tidy) {
                p4.revertAllFiles(true);
            }
        }
        catch (Exception e) {
            p4.log("(p4):stop:exception\n");
            String msg = "Unable to publish workspace: " + e;
            logger.warning(msg);
            throw e;
        }
        return true;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Boolean)this.tryTask();
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

