/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.populate.ForceCleanImpl;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class RemoveClientTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(RemoveClientTask.class.getName());
    private boolean deleteClient;
    private boolean deleteFiles;

    public RemoveClientTask(String credential, Run<?, ?> run, TaskListener listener) {
        super(credential, run, listener);
        this.useGlobalSettings();
    }

    public RemoveClientTask(String credential, Item project, TaskListener listener) {
        super(credential, project, listener);
        this.useGlobalSettings();
    }

    public void setDeleteClient(boolean deleteClient) {
        this.deleteClient = deleteClient;
    }

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    private void useGlobalSettings() {
        Jenkins j = Jenkins.getInstance();
        Descriptor scm = j.getDescriptor(PerforceScm.class);
        PerforceScm.DescriptorImpl p4scm = (PerforceScm.DescriptorImpl)scm;
        if (p4scm != null) {
            this.deleteClient = p4scm.isDeleteClient();
            this.deleteFiles = p4scm.isDeleteFiles();
        }
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        block4: {
            logger.info("Task: remove client.");
            String client = this.getClientName();
            try {
                p4.log("P4 Task: cleanup client: " + client);
                if (this.deleteFiles) {
                    ForceCleanImpl forceClean = new ForceCleanImpl(true, true, null, null);
                    p4.log("P4 Task: unsyncing client: " + client);
                    logger.info("P4: unsyncing client: " + client);
                    p4.syncFiles(new P4ChangeRef(0L), (Populate)forceClean);
                }
                if (!this.deleteClient) break block4;
                if (p4.isClient(client)) {
                    p4.revertAllFiles(false);
                    p4.log("P4 Task: remove client: " + client);
                    logger.info("P4: remove client: " + client);
                    p4.deleteClient(client);
                    break block4;
                }
                logger.warning("P4: Cannot find: " + client);
                return this.deleteFiles;
            }
            catch (Exception e) {
                logger.warning("P4: Not able to get connection");
                return false;
            }
        }
        return this.deleteFiles;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        return (Boolean)this.tryTask();
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

