/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class PublishTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(PublishTask.class.getName());
    private final Publish publish;

    public PublishTask(String credential, Run<?, ?> run, TaskListener listener, Publish publish) {
        super(credential, run, listener);
        this.publish = publish;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Boolean)this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        try {
            if (!this.checkConnection(p4)) {
                return false;
            }
            boolean open = p4.buildChange(this.publish);
            if (open) {
                p4.publishChange(this.publish);
            }
        }
        catch (Exception e) {
            p4.log("(p4):stop:exception\n");
            String msg = "Unable to publish workspace: " + e;
            p4.log(msg);
            logger.warning(msg);
            return false;
        }
        return true;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

