/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.Label;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.populate.AutoCleanImpl;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.plugins.p4.tasks.CheckoutStatus;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class CheckoutTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CheckoutTask.class.getName());
    private final Populate populate;
    private CheckoutStatus status;
    private long head;
    private List<P4Ref> builds;
    private long review;

    public CheckoutTask(String credential, Run<?, ?> run, TaskListener listener, Populate populate) {
        super(credential, run, listener);
        this.populate = populate;
    }

    public void initialise() throws AbortException {
        this.builds = new ArrayList<P4Ref>();
        try (ClientHelper p4 = new ClientHelper(this.getCredential(), this.getListener(), this.getWorkspace());){
            P4Ref buildChange;
            block32: {
                this.status = this.getStatus(this.getWorkspace());
                this.head = p4.getClientHead();
                this.review = this.getReview(this.getWorkspace());
                buildChange = this.getBuildChange(this.getWorkspace());
                if (buildChange.isLabel()) {
                    String label;
                    block31: {
                        label = buildChange.toString();
                        if (p4.isLabel(label)) {
                            Label labelSpec = p4.getLabel(label);
                            String revSpec = labelSpec.getRevisionSpec();
                            if (revSpec != null && !revSpec.isEmpty() && revSpec.startsWith("@")) {
                                try {
                                    long change = Long.parseLong(revSpec.substring(1));
                                    if (change > this.head) {
                                        buildChange = new P4ChangeRef(this.head);
                                        break block31;
                                    }
                                    buildChange = new P4ChangeRef(change);
                                }
                                catch (NumberFormatException change) {}
                            } else {
                                String warn = "P4: Warning label is static and cannot be used with polling!";
                                logger.warning(warn);
                                p4.log(warn);
                            }
                        }
                    }
                    if (p4.isCounter(label)) {
                        try {
                            String counter = p4.getCounter(label);
                            long change = Long.parseLong(counter);
                            if (change > this.head) {
                                buildChange = new P4ChangeRef(this.head);
                                break block32;
                            }
                            buildChange = new P4ChangeRef(change);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (buildChange.getChange() > this.head) {
                    buildChange = new P4ChangeRef(this.head);
                }
            }
            if (buildChange.getChange() > 0L) {
                long rangeLimit = buildChange.getChange() - p4.getHeadLimit();
                rangeLimit = rangeLimit < 0L ? 1L : rangeLimit;
                P4ChangeRef limitRef = p4.getHeadLimit() == 0L ? null : new P4ChangeRef(rangeLimit);
                buildChange = new P4ChangeRef(p4.getClientHead(limitRef, buildChange));
            }
            this.builds.add(buildChange);
            if (p4.checkVersion(20171)) {
                List<IRepo> repos = p4.listRepos();
                for (IRepo repo : repos) {
                    P4Ref graphHead = p4.getGraphHead(repo.getName());
                    this.builds.add(graphHead);
                }
            }
            StringBuffer buildReport = new StringBuffer("P4: builds: ");
            for (P4Ref build : this.builds) {
                buildReport.append(build.toString() + " ");
            }
            p4.log(buildReport.toString());
        }
        catch (Exception e) {
            String err = "P4: Unable to initialise CheckoutTask: " + e;
            logger.severe(err);
            throw new AbortException(err);
        }
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Boolean)this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        p4.tidyWorkspace(this.populate);
        for (P4Ref build : this.builds) {
            p4.syncFiles(build, this.populate);
        }
        if (this.status == CheckoutStatus.SHELVED) {
            p4.unshelveFiles(this.review);
            if (this.populate instanceof AutoCleanImpl) {
                AutoCleanImpl auto = (AutoCleanImpl)this.populate;
                if (auto.isTidy()) {
                    p4.revertAllFiles(true);
                }
            } else if (!this.populate.isHave()) {
                p4.revertAllFiles(true);
            }
        }
        return true;
    }

    private CheckoutStatus getStatus(Workspace workspace) {
        CheckoutStatus status = CheckoutStatus.HEAD;
        String value = workspace.getExpand().get(ReviewProp.SWARM_STATUS.toString());
        if (value != null && !value.isEmpty()) {
            status = CheckoutStatus.parse(value);
        }
        return status;
    }

    private P4Ref getBuildChange(Workspace workspace) {
        String lblStr;
        String cngStr;
        long change2;
        String expandedPopulateLabel;
        P4Ref build = new P4ChangeRef(this.head);
        Expand expand = workspace.getExpand();
        String populateLabel = this.populate.getPin();
        if (populateLabel != null && !populateLabel.isEmpty() && !(expandedPopulateLabel = expand.format(populateLabel, false)).isEmpty()) {
            try {
                change2 = Long.parseLong(expandedPopulateLabel);
                build = new P4ChangeRef(change2);
                logger.info("getBuildChange:pinned:change:" + change2);
            }
            catch (NumberFormatException e) {
                build = new P4LabelRef(expandedPopulateLabel);
                logger.info("getBuildChange:pinned:label:" + expandedPopulateLabel);
            }
        }
        if ((cngStr = expand.get(ReviewProp.P4_CHANGE.toString())) != null && !cngStr.isEmpty()) {
            try {
                change2 = Long.parseLong(cngStr);
                build = new P4ChangeRef(change2);
                logger.info("getBuildChange:ReviewProp:CHANGE:" + change2);
            }
            catch (NumberFormatException change2) {
                // empty catch block
            }
        }
        if ((lblStr = expand.get(ReviewProp.P4_LABEL.toString())) != null && !lblStr.isEmpty()) {
            try {
                long change3 = Long.parseLong(lblStr);
                build = new P4ChangeRef(change3);
                logger.info("getBuildChange:ReviewProp:LABEL:" + change3);
            }
            catch (NumberFormatException e) {
                build = new P4LabelRef(lblStr);
                logger.info("getBuildChange:ReviewProp:LABEL:" + lblStr);
            }
        }
        logger.info("getBuildChange:return:" + build);
        return build;
    }

    private long getReview(Workspace workspace) {
        long review = 0L;
        Expand expand = workspace.getExpand();
        String value = expand.get(ReviewProp.SWARM_REVIEW.toString());
        if (value != null && !value.isEmpty()) {
            try {
                review = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return review;
    }

    public List<P4ChangeEntry> getChangesFull(List<P4Ref> lastRefs) {
        ArrayList<P4ChangeEntry> changesFull = new ArrayList<P4ChangeEntry>();
        try (ClientHelper p4 = new ClientHelper(this.getCredential(), this.getListener(), this.getWorkspace());){
            if (this.status == CheckoutStatus.SHELVED) {
                P4ChangeEntry cl = new P4ChangeEntry();
                Changelist pending = p4.getChange(this.review);
                cl.setChange(p4, (IChangelistSummary)pending);
                changesFull.add(cl);
            }
            for (P4Ref build : this.builds) {
                P4ChangeEntry cl;
                if (build.isCommit()) {
                    List<P4Ref> commits = p4.listCommits(lastRefs, build);
                    for (P4Ref ref : commits) {
                        cl = ref.getChangeEntry(p4);
                        changesFull.add(cl);
                    }
                    continue;
                }
                List<P4Ref> changes = p4.listChanges(lastRefs, build);
                for (P4Ref change : changes) {
                    cl = change.getChangeEntry(p4);
                    changesFull.add(cl);
                }
            }
        }
        catch (Exception e) {
            String err = "Unable to get full changes: " + e;
            logger.severe(err);
            e.printStackTrace();
        }
        return changesFull;
    }

    public P4ChangeEntry getCurrentChange() {
        P4ChangeEntry cl = new P4ChangeEntry();
        P4Ref current = this.getBuildChange();
        try (ClientHelper p4 = new ClientHelper(this.getCredential(), this.getListener(), this.getWorkspace());){
            cl = current.getChangeEntry(p4);
        }
        catch (Exception e) {
            String err = "Unable to get current change: " + e;
            logger.severe(err);
            e.printStackTrace();
        }
        return cl;
    }

    public CheckoutStatus getStatus() {
        return this.status;
    }

    public List<P4Ref> getSyncChange() {
        return this.builds;
    }

    public P4Ref getBuildChange() {
        if (this.status == CheckoutStatus.SHELVED) {
            return new P4ChangeRef(this.review);
        }
        for (P4Ref build : this.builds) {
            if (build.isCommit()) continue;
            return build;
        }
        return null;
    }

    public void setBuildChange(P4Ref parentChange) {
        this.builds = new ArrayList<P4Ref>();
        this.builds.add(parentChange);
    }

    public void setIncrementalChanges(List<P4Ref> changes) {
        if (changes != null && !changes.isEmpty()) {
            P4Ref lowest = changes.get(changes.size() - 1);
            this.builds = new ArrayList<P4Ref>();
            this.builds.add(lowest);
        }
    }

    public long getReview() {
        return this.review;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

