/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm.events;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4SCMRevision;

public class P4BranchSCMHeadEvent
extends SCMHeadEvent<JSONObject> {
    public P4BranchSCMHeadEvent(@NonNull SCMEvent.Type type, JSONObject payload, String origin) {
        super(type, (Object)payload, origin);
    }

    @NonNull
    public String getSourceName() {
        String p4port = P4BranchSCMHeadEvent.getField((JSONObject)this.getPayload(), ReviewProp.P4_PORT);
        String change = P4BranchSCMHeadEvent.getField((JSONObject)this.getPayload(), ReviewProp.P4_CHANGE);
        return p4port + "/" + change;
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource scmSource) {
        if (!(scmSource instanceof AbstractP4ScmSource)) {
            return Collections.emptyMap();
        }
        AbstractP4ScmSource source = (AbstractP4ScmSource)scmSource;
        String p4port = P4BranchSCMHeadEvent.getField((JSONObject)this.getPayload(), ReviewProp.P4_PORT);
        String id = source.getCredential();
        P4BaseCredentials credential = ConnectionHelper.findCredential(id, (Item)scmSource.getOwner());
        if (p4port == null || !p4port.equals(credential.getP4port())) {
            return Collections.emptyMap();
        }
        P4SCMRevision revision = source.getRevision((JSONObject)this.getPayload());
        if (revision == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(revision.getHead(), revision);
    }

    public boolean isMatch(@NonNull SCM scm) {
        return true;
    }

    public boolean isMatch(@NonNull SCMNavigator scmNavigator) {
        return false;
    }

    private static String getField(JSONObject payload, ReviewProp prop) {
        return payload.getString(prop.getProp());
    }
}

