/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.util.NonLocalizable;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.browsers.SwarmBrowser;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.changes.P4RefBuilder;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.client.ViewMapHelper;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4ChangeRequestSCMHead;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;
import org.jenkinsci.plugins.p4.scm.P4SCMRevision;
import org.jenkinsci.plugins.p4.scm.P4SCMSourceDescriptor;
import org.jenkinsci.plugins.p4.scm.events.P4BranchScanner;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmHelper;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmProjectAPI;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmReviewAPI;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmReviewsAPI;
import org.jenkinsci.plugins.p4.tasks.CheckoutStatus;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SwarmScmSource
extends AbstractP4ScmSource {
    private static Logger logger = Logger.getLogger(SwarmScmSource.class.getName());
    private String project;
    private transient SwarmHelper swarm;

    @DataBoundConstructor
    public SwarmScmSource(String credential, String charset, String format) throws Exception {
        super(credential);
        this.setCharset(charset);
        this.setFormat(format);
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public SwarmHelper getSwarm() throws Exception {
        if (this.swarm == null) {
            try (ConnectionHelper p4 = new ConnectionHelper((Item)this.getOwner(), this.credential, null);){
                this.swarm = new SwarmHelper(p4, "4");
            }
        }
        return this.swarm;
    }

    public void setSwarm(SwarmHelper swarm) {
        this.swarm = swarm;
    }

    @Override
    public P4Browser getBrowser() {
        try {
            return new SwarmBrowser(this.getSwarm().getBaseUrl());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<P4SCMHead> getTags(@NonNull TaskListener listener) throws Exception {
        ArrayList<P4SCMHead> list = new ArrayList<P4SCMHead>();
        List<SwarmReviewsAPI.Reviews> reviews = this.getSwarm().getActiveReviews(this.project);
        for (SwarmReviewsAPI.Reviews review : reviews) {
            String reviewID = String.valueOf(review.getId());
            List<String> branches = this.getBranchesInReview(reviewID, this.project);
            for (String branch : branches) {
                P4Path p4Path = this.getPathsInBranch(branch, this.project);
                if (p4Path == null) continue;
                p4Path.setRevision(reviewID);
                String trgName = reviewID;
                P4SCMHead target = new P4SCMHead(trgName, p4Path);
                P4ChangeRequestSCMHead tag = new P4ChangeRequestSCMHead(trgName, reviewID, p4Path, target);
                list.add(tag);
            }
        }
        return list;
    }

    @Override
    public List<P4SCMHead> getHeads(@NonNull TaskListener listener) throws Exception {
        ArrayList<P4SCMHead> list = new ArrayList<P4SCMHead>();
        List<SwarmProjectAPI.Branch> branches = this.getSwarm().getBranchesInProject(this.project);
        for (SwarmProjectAPI.Branch branch : branches) {
            P4Path p4Path = branch.getPath();
            P4SCMHead head = new P4SCMHead(branch.getId(), p4Path);
            list.add(head);
        }
        return list;
    }

    @Override
    public P4SCMRevision getRevision(P4SCMHead head, TaskListener listener) throws Exception {
        if (head instanceof P4ChangeRequestSCMHead) {
            P4ChangeRequestSCMHead changeRequest = (P4ChangeRequestSCMHead)head;
            String review = changeRequest.getReview();
            long change = this.getLastChangeInReview(review);
            P4SCMRevision revision = new P4SCMRevision(head, new P4ChangeRef(change));
            return revision;
        }
        return super.getRevision(head, listener);
    }

    @Override
    public P4SCMRevision getRevision(JSONObject payload) {
        String change = this.getProperty(payload, ReviewProp.P4_CHANGE);
        if (change == null) {
            return null;
        }
        String project = this.getProperty(payload, ReviewProp.SWARM_PROJECT);
        if (project == null || !project.equalsIgnoreCase(this.getProject())) {
            P4Ref ref = P4RefBuilder.get(change);
            P4BranchScanner scanner = this.getScanner(ref);
            if (scanner == null) {
                return null;
            }
            String base = scanner.getProjectRoot();
            String branch = scanner.getBranch();
            String path = base + "/" + branch;
            return P4SCMRevision.swarmBuilder(path, branch, ref);
        }
        String branch = this.getProperty(payload, ReviewProp.SWARM_BRANCH);
        String path = this.getProperty(payload, ReviewProp.SWARM_PATH);
        String status = this.getProperty(payload, ReviewProp.SWARM_STATUS);
        if (branch == null || path == null || status == null) {
            return null;
        }
        CheckoutStatus checkoutStatus = CheckoutStatus.parse(status);
        P4ChangeRef ref = new P4ChangeRef(Long.parseLong(change));
        switch (checkoutStatus) {
            case SUBMITTED: 
            case COMMITTED: {
                logger.fine("SCM Swarm: COMMITTED: path: " + path + " branch: " + branch + " ref: " + ref);
                return P4SCMRevision.swarmBuilder(path, branch, ref);
            }
            case SHELVED: {
                String review = this.getProperty(payload, ReviewProp.SWARM_REVIEW);
                if (review == null) {
                    return null;
                }
                logger.fine("SCM Swarm: SHELVED: path: " + path + " branch: " + branch + " ref: " + ref + " review: " + review);
                return P4SCMRevision.swarmBuilder(path, branch, ref, review);
            }
        }
        return null;
    }

    @Override
    protected boolean findInclude(String path) {
        List<SwarmProjectAPI.Branch> branches;
        try {
            branches = this.getSwarm().getBranchesInProject(this.project);
        }
        catch (Exception e) {
            return false;
        }
        for (SwarmProjectAPI.Branch branch : branches) {
            for (String p : branch.getPaths()) {
                if (!p.startsWith(path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Workspace getWorkspace(P4Path path) {
        if (path == null) {
            throw new IllegalArgumentException("missing path");
        }
        String client = this.getFormat();
        String jenkinsView = ViewMapHelper.getScriptView(path.getPath(), this.getScriptPathOrDefault(), client);
        String mappingsView = ViewMapHelper.getClientView(path.getMappings(), client, false, true);
        String view = mappingsView + "\n" + jenkinsView;
        WorkspaceSpec spec = new WorkspaceSpec(view, null);
        return new ManualWorkspaceImpl(this.getCharset(), false, client, spec);
    }

    @Override
    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        return true;
    }

    private List<String> getBranchesInReview(String review, String project) throws Exception {
        SwarmReviewAPI api = this.getSwarm().getSwarmReview(review);
        HashMap<String, List<String>> projects = api.getReview().getProjects();
        List<String> branches = projects.get(project);
        return branches;
    }

    private long getLastChangeInReview(String review) throws Exception {
        SwarmReviewAPI api = this.getSwarm().getSwarmReview(review);
        List<Long> changes = api.getReview().getChanges();
        long lastChange = 0L;
        for (Long change : changes) {
            if (change <= lastChange) continue;
            lastChange = change;
        }
        return lastChange;
    }

    private P4Path getPathsInBranch(String id, String project) throws Exception {
        List<SwarmProjectAPI.Branch> branches = this.getSwarm().getBranchesInProject(project);
        for (SwarmProjectAPI.Branch branch : branches) {
            if (!id.equals(branch.getId())) continue;
            P4Path swarmPath = branch.getPath();
            return swarmPath;
        }
        return null;
    }

    @Extension
    @Symbol(value={"multiSwarm"})
    public static final class DescriptorImpl
    extends P4SCMSourceDescriptor {
        public String getDisplayName() {
            return "Helix Swarm";
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory((Localizable)new NonLocalizable("Branches")), new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("Reviews"))};
        }
    }
}

