/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import com.perforce.p4java.core.IStreamSummary;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;
import org.jenkinsci.plugins.p4.scm.P4SCMSourceDescriptor;
import org.jenkinsci.plugins.p4.workspace.StreamWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class StreamsScmSource
extends AbstractP4ScmSource {
    private P4Browser browser;

    @DataBoundConstructor
    public StreamsScmSource(String credential, String includes, String charset, String format) {
        super(credential);
        this.setIncludes(includes);
        this.setCharset(charset);
        this.setFormat(format);
    }

    @DataBoundSetter
    public void setBrowser(P4Browser browser) {
        this.browser = browser;
    }

    @Override
    public P4Browser getBrowser() {
        return this.browser;
    }

    @Override
    public List<P4SCMHead> getTags(@NonNull TaskListener listener) throws Exception {
        return new ArrayList<P4SCMHead>();
    }

    @Override
    public List<P4SCMHead> getHeads(@NonNull TaskListener listener) throws Exception {
        List<String> paths = this.getIncludePaths();
        HashSet<P4SCMHead> list = new HashSet<P4SCMHead>();
        try (ConnectionHelper p4 = new ConnectionHelper((Item)this.getOwner(), this.credential, listener);){
            List<IStreamSummary> specs = p4.getStreams(paths);
            for (IStreamSummary s : specs) {
                String name = s.getName();
                String stream = s.getStream();
                P4Path p4Path = new P4Path(stream);
                P4SCMHead head = new P4SCMHead(name, p4Path);
                list.add(head);
            }
        }
        return new ArrayList<P4SCMHead>(list);
    }

    @Override
    public Workspace getWorkspace(P4Path path) {
        return new StreamWorkspaceImpl(this.getCharset(), false, path.getPath(), this.getFormat());
    }

    @Extension
    @Symbol(value={"multiStreams"})
    public static final class DescriptorImpl
    extends P4SCMSourceDescriptor {
        public String getDisplayName() {
            return "Helix Streams";
        }
    }
}

