/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;

public class P4SCMProbe
extends SCMProbe {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(P4SCMProbe.class.getName());
    private final P4SCMHead head;
    private transient ConnectionHelper p4;

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.p4.scm.P4Probe", P4SCMProbe.class);
    }

    public P4SCMProbe(ConnectionHelper p4, P4SCMHead head) {
        this.head = head;
        this.p4 = p4;
    }

    public String name() {
        return this.head.getName();
    }

    public long lastModified() {
        long last = 0L;
        try {
            P4Path path = this.head.getPath();
            long change = this.p4.getHead(path.getPathBuilder("..."));
            if (change > last) {
                last = change;
            }
        }
        catch (Exception e) {
            logger.warning("Unable to check changes: " + e.getMessage());
        }
        return last;
    }

    public SCMProbeStat stat(@NonNull String file) throws IOException {
        try {
            P4Path path = this.head.getPath();
            String depotPath = path.getPathBuilder(file);
            if (this.p4.hasFile(depotPath)) {
                return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to check file: " + e.getMessage());
        }
        return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
    }

    public void close() throws IOException {
    }
}

