/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetExtendedFilesOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jenkins.scm.api.SCMFile;
import org.jenkinsci.plugins.p4.client.NavigateHelper;
import org.jenkinsci.plugins.p4.client.TempClientHelper;
import org.jenkinsci.plugins.p4.scm.P4SCMFileSystem;

public class P4SCMFile
extends SCMFile {
    private final P4SCMFileSystem fs;
    private final boolean isDir;

    public P4SCMFile(P4SCMFileSystem fs) {
        this.fs = fs;
        this.isDir = true;
    }

    public P4SCMFile(P4SCMFileSystem fs, @NonNull P4SCMFile parent, String name, boolean isDir) {
        super((SCMFile)parent, name);
        this.fs = fs;
        this.isDir = isDir;
    }

    protected SCMFile newChild(@NonNull String name, boolean assumeIsDirectory) {
        return new P4SCMFile(this.fs, this, name, assumeIsDirectory);
    }

    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        String path = this.getPath();
        TempClientHelper p4 = this.fs.getConnection();
        NavigateHelper nav = new NavigateHelper(p4.getConnection());
        ArrayList<SCMFile> list = new ArrayList<SCMFile>();
        List<NavigateHelper.Node> nodes = nav.getNodes(path);
        for (NavigateHelper.Node node : nodes) {
            list.add(this.newChild(node.getName(), node.isDir()));
        }
        return list;
    }

    public long lastModified() throws IOException, InterruptedException {
        TempClientHelper p4 = this.fs.getConnection();
        List<IFileSpec> file = this.getFileSpec();
        GetExtendedFilesOptions exOpts = new GetExtendedFilesOptions();
        try {
            List fstat = p4.getConnection().getExtendedFiles(file, exOpts);
            if (((IExtendedFileSpec)fstat.get(0)).getOpStatus().equals((Object)FileSpecOpStatus.VALID)) {
                Date date = ((IExtendedFileSpec)fstat.get(0)).getHeadModTime();
                return date.getTime();
            }
        }
        catch (P4JavaException e) {
            throw new IOException(e);
        }
        return 0L;
    }

    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isDir) {
            return SCMFile.Type.DIRECTORY;
        }
        TempClientHelper p4 = this.fs.getConnection();
        List<IFileSpec> file = this.getFileSpec();
        GetExtendedFilesOptions exOpts = new GetExtendedFilesOptions();
        try {
            List fstat = p4.getConnection().getExtendedFiles(file, exOpts);
            if (((IExtendedFileSpec)fstat.get(0)).getOpStatus().equals((Object)FileSpecOpStatus.VALID)) {
                String type = ((IExtendedFileSpec)fstat.get(0)).getHeadType();
                if (type.startsWith("symlink")) {
                    return SCMFile.Type.LINK;
                }
                return SCMFile.Type.REGULAR_FILE;
            }
        }
        catch (P4JavaException e) {
            throw new IOException(e);
        }
        return SCMFile.Type.NONEXISTENT;
    }

    public InputStream content() throws IOException, InterruptedException {
        TempClientHelper p4 = this.fs.getConnection();
        List<IFileSpec> file = this.getFileSpec();
        GetFileContentsOptions printOpts = new GetFileContentsOptions();
        printOpts.setNoHeaderLine(true);
        try {
            return p4.getConnection().getFileContents(file, printOpts);
        }
        catch (P4JavaException e) {
            throw new IOException(e);
        }
    }

    private List<IFileSpec> getFileSpec() {
        String clientPath = "//" + this.fs.getConnection().getClientUUID() + "/";
        String path = this.getPath();
        if (!path.startsWith(clientPath)) {
            path = clientPath + path;
        }
        List file = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        return file;
    }
}

