/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.groovy;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class P4GroovyTask
extends AbstractTask
implements FilePath.FileCallable<Map<String, Object>[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(P4GroovyTask.class.getName());
    private final String cmd;
    private final String[] args;
    private final Map<String, Object> spec;

    protected P4GroovyTask(P4BaseCredentials credential, TaskListener listener, String cmd, String[] args, Map<String, Object> spec) {
        super(credential, listener);
        this.cmd = cmd;
        this.args = Arrays.copyOf(args, args.length);
        this.spec = spec;
    }

    protected P4GroovyTask(P4BaseCredentials credential, TaskListener listener, String cmd, String ... args) {
        this(credential, listener, cmd, args, (Map<String, Object>)null);
    }

    public Map<String, Object>[] invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Map[])this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        try {
            if (!this.checkConnection(p4)) {
                return null;
            }
            return p4.getConnection().execMapCmd(this.cmd, this.args, this.spec);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("P4: Unable to execute p4 groovy task: ");
            sb.append(this.cmd == null ? "[null]" : this.cmd).append(" ");
            sb.append(this.args == null ? "[null]" : Arrays.toString(this.args)).append(": ");
            sb.append(e.toString());
            String err = sb.toString();
            logger.severe(err);
            p4.log(err);
            throw e;
        }
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

